/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.util.DependencyExtractor;
import org.eclipse.recommenders.jdt.templates.SnippetCodeBuilder;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditor;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateSnippetHandler
extends AbstractHandler {
    private ExecutionEvent event;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        CompilationUnitEditor editor = (CompilationUnitEditor)Checks.cast((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        Snippet snippet = this.createSnippet(editor);
        this.openSnippetInEditor(snippet);
        return null;
    }

    @VisibleForTesting
    Snippet createSnippet(CompilationUnitEditor editor) throws ExecutionException {
        ISourceViewer viewer = editor.getViewer();
        ITypeRoot root = (ITypeRoot)Checks.cast((Object)editor.getViewPartInput());
        CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)root, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        IDocument doc = viewer.getDocument();
        ITextSelection textSelection = (ITextSelection)Checks.cast((Object)viewer.getSelectionProvider().getSelection());
        IProjectCoordinateProvider pcProvider = (IProjectCoordinateProvider)InjectionService.getInstance().requestInstance(IProjectCoordinateProvider.class);
        String code = new SnippetCodeBuilder(ast, doc, (IRegion)new Region(textSelection.getOffset(), textSelection.getLength())).build();
        Set<ProjectCoordinate> dependencies = new DependencyExtractor(ast, textSelection, pcProvider).extractDependencies();
        return new Snippet(code, dependencies);
    }

    private void openSnippetInEditor(Snippet snippet) {
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event).getActivePage();
        try {
            SnippetEditorInput input = new SnippetEditorInput((ISnippet)snippet);
            SnippetEditor ed = (SnippetEditor)((Object)Checks.cast((Object)page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet")));
            ed.markDirtyUponSnippetCreation();
        }
        catch (PartInitException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_OPEN_EDITOR, (Throwable)e);
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND, (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND_HINT);
        }
    }
}

