/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.impl.poll;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.impl.poll.Proxies;
import org.eclipse.recommenders.news.impl.poll.IDownloadService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DefaultDownloadService
implements IDownloadService {
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long SOCKET_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final Executor executor = Executor.newInstance();
    private final Path downloadLocation;

    public DefaultDownloadService() {
        this(DefaultDownloadService.getStateLocation().resolve("downloads"));
    }

    @VisibleForTesting
    DefaultDownloadService(Path downloadLocation) {
        this.downloadLocation = downloadLocation;
    }

    private static Path getStateLocation() {
        Bundle bundle = FrameworkUtil.getBundle(DefaultDownloadService.class);
        return Platform.getStateLocation((Bundle)bundle).toFile().toPath();
    }

    @Override
    public InputStream download(URI uri, @Nullable IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            String fileName = this.mangleUri(uri);
            Path targetPath = this.downloadLocation.resolve(fileName);
            this.doDownload(uri, fileName, targetPath, progress.newChild(1));
            InputStream inputStream = Files.newInputStream(targetPath, new OpenOption[0]);
            return inputStream;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void doDownload(URI uri, String fileName, Path targetFile, SubMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        Path tempFile = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (InputStream resourceStream = this.openWebResourceAsStream(uri, progress.newChild(1));){
                    Files.createDirectories(this.downloadLocation, new FileAttribute[0]);
                    tempFile = Files.createTempFile(this.downloadLocation, null, fileName, new FileAttribute[0]);
                    progress.worked(1);
                    Files.copy(resourceStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    progress.worked(1);
                    Files.move(tempFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    progress.worked(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                progress.setWorkRemaining(0);
                try {
                    Files.setLastModifiedTime(targetFile, FileTime.fromMillis(System.currentTimeMillis()));
                }
                catch (IOException failedToSetLastModifiedTime) {
                    e.addSuppressed(failedToSetLastModifiedTime);
                    try {
                        Files.createFile(targetFile, new FileAttribute[0]);
                    }
                    catch (IOException failedToCreateFile) {
                        e.addSuppressed(failedToCreateFile);
                    }
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (tempFile != null) {
                Files.deleteIfExists(tempFile);
            }
            throw throwable;
        }
        if (tempFile != null) {
            Files.deleteIfExists(tempFile);
        }
    }

    private String mangleUri(URI uri) {
        try {
            return URLEncoder.encode(uri.toASCIIString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(uri.toString(), e);
        }
    }

    private InputStream openWebResourceAsStream(URI uri, SubMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            Request request = Request.Get((URI)uri).viaProxy(Proxies.getProxyHost(uri)).connectTimeout((int)CONNECTION_TIMEOUT).staleConnectionCheck(true).socketTimeout((int)SOCKET_TIMEOUT);
            Response response = Proxies.proxyAuthentication(this.executor, uri).execute(request);
            HttpResponse returnResponse = response.returnResponse();
            StatusLine statusLine = returnResponse.getStatusLine();
            if (statusLine == null) {
                throw new IOException();
            }
            if (statusLine.getStatusCode() >= 400) {
                throw new IOException(statusLine.getReasonPhrase());
            }
            HttpEntity entity = returnResponse.getEntity();
            if (entity == null || entity.getContentLength() == 0L) {
                throw new IOException("Empty representation");
            }
            InputStream inputStream = entity.getContent();
            return inputStream;
        }
        finally {
            progress.worked(1);
        }
    }

    @Override
    @Nullable
    public InputStream read(URI uri) throws IOException {
        String fileName = this.mangleUri(uri);
        Path targetPath = this.downloadLocation.resolve(fileName);
        try {
            if (Files.size(targetPath) == 0L) {
                throw new IOException("Empty representation");
            }
            return Files.newInputStream(targetPath, new OpenOption[0]);
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Override
    @Nullable
    public Date getLastAttemptDate(URI uri) throws IOException {
        String fileName = this.mangleUri(uri);
        Path targetPath = this.downloadLocation.resolve(fileName);
        try {
            return new Date(Files.getLastModifiedTime(targetPath, new LinkOption[0]).toMillis());
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        catch (IOException e) {
            throw e;
        }
    }
}

