/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.preferences;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptors;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.preferences.FeedDialog;
import org.eclipse.recommenders.internal.news.rcp.preferences.LinkEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class NewsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor enabledEditor;
    private FeedEditor feedEditor;
    private IntegerFieldEditor startupEditor;

    public NewsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.news.rcp"));
        this.setMessage(Messages.PREFPAGE_TITLE);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
    }

    protected void createFieldEditors() {
        this.enabledEditor = new BooleanFieldEditor("newsEnabled", Messages.FIELD_LABEL_NEWS_ENABLED, 0, this.getFieldEditorParent()){

            protected void valueChanged(boolean oldValue, boolean newValue) {
                super.valueChanged(oldValue, newValue);
                NewsPreferencePage.this.startupEditor.setEnabled(NewsPreferencePage.this.enabledEditor.getBooleanValue(), NewsPreferencePage.this.getFieldEditorParent());
            }
        };
        this.addField((FieldEditor)this.enabledEditor);
        this.startupEditor = new IntegerFieldEditor("pollingDelay", Messages.FIELD_LABEL_STARTUP_DELAY, this.getFieldEditorParent(), 4);
        this.startupEditor.setEnabled(this.getPreferenceStore().getBoolean("newsEnabled"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.startupEditor);
        Composite bottomGroup = new Composite(this.getFieldEditorParent(), 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)bottomGroup);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(bottomGroup);
        this.feedEditor = new FeedEditor("feed.list.sorted", Messages.FIELD_LABEL_FEEDS, bottomGroup);
        this.addField(this.feedEditor);
        this.addField(new LinkEditor(Messages.PREFPAGE_NOTIFICATION_ENABLEMENT, "org.eclipse.mylyn.commons.notifications.preferencePages.Notifications", this.getFieldEditorParent()));
        this.addField(new LinkEditor(Messages.PREFPAGE_WEB_BROWSER_SETTINGS, "org.eclipse.ui.browser.preferencePage", this.getFieldEditorParent()));
        Dialog.applyDialogFont((Control)this.getControl());
    }

    private final class FeedEditor
    extends FieldEditor {
        private CheckboxTableViewer tableViewer;
        private Composite buttonBox;
        private Button newButton;
        private Button editButton;
        private Button removeButton;

        private FeedEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            Label control = this.getLabelControl(parent);
            GridDataFactory.swtDefaults().span(numColumns, 1).applyTo((Control)control);
            this.tableViewer = this.getTableControl(parent);
            GridDataFactory.fillDefaults().align(4, 4).span(numColumns - 1, 1).grab(true, true).applyTo((Control)this.tableViewer.getTable());
            this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int cfr_ignored_0 = e.detail;
                    FeedEditor.this.updateButtonStatus();
                }
            });
            this.tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    boolean isClickOnCheckbox;
                    FeedEditor.this.tableViewer.setSelection((ISelection)new StructuredSelection(FeedDescriptor.class), true);
                    TableItem item = FeedEditor.this.tableViewer.getTable().getItem(new Point(e.x, e.y));
                    if (item == null) {
                        return;
                    }
                    Rectangle bounds = item.getBounds();
                    boolean bl = isClickOnCheckbox = e.x < bounds.x;
                    if (isClickOnCheckbox) {
                        return;
                    }
                    FeedDescriptor feed = (FeedDescriptor)item.getData();
                    if (!feed.isDefaultRepository()) {
                        FeedEditor.this.editFeed(feed);
                    }
                    FeedEditor.this.updateButtonStatus();
                }
            });
            this.buttonBox = this.getButtonControl(parent);
            this.updateButtonStatus();
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)this.buttonBox);
        }

        private void updateButtonStatus() {
            boolean selected = this.tableViewer.getTable().getSelectionIndex() != -1;
            FeedDescriptor feed = this.getSelectedFeed();
            if (feed == null) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                return;
            }
            this.editButton.setEnabled(selected && !feed.isDefaultRepository());
            this.removeButton.setEnabled(selected && !feed.isDefaultRepository());
        }

        private Composite getButtonControl(Composite parent) {
            Composite box = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(box);
            this.newButton = this.createButton(box, Messages.PREFPAGE_BUTTON_NEW);
            this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedEditor.this.addNewFeed();
                    FeedEditor.this.updateButtonStatus();
                }
            });
            this.editButton = this.createButton(box, Messages.PREFPAGE_BUTTON_EDIT);
            this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedEditor.this.editFeed(FeedEditor.this.getSelectedFeed());
                    FeedEditor.this.updateButtonStatus();
                }
            });
            this.editButton.setEnabled(false);
            this.removeButton = this.createButton(box, Messages.PREFPAGE_BUTTON_REMOVE);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedEditor.this.removeFeed(FeedEditor.this.getSelectedFeed());
                    FeedEditor.this.updateButtonStatus();
                }
            });
            return box;
        }

        private FeedDescriptor getSelectedFeed() {
            IStructuredSelection selected = (IStructuredSelection)this.tableViewer.getSelection();
            return (FeedDescriptor)selected.getFirstElement();
        }

        protected void removeFeed(FeedDescriptor feed) {
            List<FeedDescriptor> feeds = this.getTableInput();
            feeds.remove(feed);
            this.updateTableContent(feeds);
        }

        protected void editFeed(FeedDescriptor oldFeed) {
            List descriptors = (List)this.tableViewer.getInput();
            FeedDialog dialog = new FeedDialog(NewsPreferencePage.this.getShell(), oldFeed, descriptors);
            List<FeedDescriptor> feeds = this.getTableInput();
            if (dialog.open() == 0) {
                int index = feeds.indexOf(oldFeed);
                feeds.remove(oldFeed);
                feeds.add(index, dialog.getFeed());
                this.updateTableContent(feeds);
            }
        }

        private List<FeedDescriptor> getTableInput() {
            List configurations = (List)this.tableViewer.getInput();
            if (configurations == null) {
                return new ArrayList<FeedDescriptor>();
            }
            return new ArrayList<FeedDescriptor>(configurations);
        }

        protected void addNewFeed() {
            List descriptors = (List)this.tableViewer.getInput();
            FeedDialog dialog = new FeedDialog(NewsPreferencePage.this.getShell(), descriptors);
            List<FeedDescriptor> feeds = this.getTableInput();
            if (dialog.open() == 0) {
                feeds.add(dialog.getFeed());
                this.updateTableContent(feeds);
            }
        }

        private Button createButton(Composite box, String text) {
            Button button = new Button(box, 8);
            button.setText(text);
            int widthHint = Math.max(this.convertHorizontalDLUsToPixels((Control)button, 61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            GridDataFactory.swtDefaults().align(4, 0x1000000).hint(widthHint, -1).applyTo((Control)button);
            return button;
        }

        private CheckboxTableViewer getTableControl(Composite parent) {
            CheckboxTableViewer tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67584);
            tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    FeedDescriptor feed = (FeedDescriptor)element;
                    if (Strings.isNullOrEmpty((String)feed.getContributedBy())) {
                        return feed.getName();
                    }
                    return MessageFormat.format(Messages.FEED_CONTRIBUTED_BY, feed.getName(), feed.getContributedBy());
                }

                public String getToolTipText(Object element) {
                    FeedDescriptor feed = (FeedDescriptor)element;
                    return MessageFormat.format(Messages.FEED_TOOLTIP, feed.getUri(), feed.getPollingInterval());
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            return tableViewer;
        }

        protected void doLoad() {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.load(value, false);
        }

        private void load(String value, boolean loadDefaults) {
            List<FeedDescriptor> input = FeedDescriptors.load(value, FeedDescriptors.getRegisteredFeeds());
            if (!loadDefaults) {
                input.addAll(FeedDescriptors.getFeeds(this.getPreferenceStore().getString("custom.feed.list.sorted")));
            }
            ArrayList checkedElements = Lists.newArrayList();
            for (FeedDescriptor feed : input) {
                if (!feed.isEnabled()) continue;
                checkedElements.add(feed);
            }
            this.tableViewer.setInput(input);
            this.tableViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String feedName = Strings.nullToEmpty((String)((FeedDescriptor)e1).getName());
                    String otherFeedName = Strings.nullToEmpty((String)((FeedDescriptor)e2).getName());
                    return ComparisonChain.start().compare((Object)feedName, (Object)otherFeedName, String.CASE_INSENSITIVE_ORDER).compare((Comparable)((Object)feedName), (Comparable)((Object)otherFeedName)).result();
                }
            });
            this.tableViewer.setCheckedElements(checkedElements.toArray());
        }

        public void updateTableContent(List<FeedDescriptor> feeds) {
            final List<FeedDescriptor> oldFeeds = this.getTableInput();
            Collection checkedFeeds = Collections2.filter(feeds, (Predicate)new Predicate<FeedDescriptor>(){

                public boolean apply(FeedDescriptor input) {
                    if (oldFeeds != null && oldFeeds.contains(input)) {
                        return FeedEditor.this.tableViewer.getChecked((Object)input);
                    }
                    return input.isEnabled();
                }
            });
            this.tableViewer.setInput(feeds);
            this.tableViewer.setCheckedElements(checkedFeeds.toArray());
        }

        public void loadDefault() {
            super.loadDefault();
            this.setPresentsDefaultValue(false);
        }

        protected void doLoadDefault() {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.load(value, true);
        }

        protected void doStore() {
            List descriptors = (List)this.tableViewer.getInput();
            for (FeedDescriptor descriptor : descriptors) {
                descriptor.setEnabled(this.tableViewer.getChecked((Object)descriptor));
            }
            ArrayList feeds = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)new Predicate<FeedDescriptor>(){

                public boolean apply(FeedDescriptor input) {
                    return input.isDefaultRepository();
                }
            }));
            ArrayList customFeeds = Lists.newArrayList((Iterable)Iterables.filter((Iterable)descriptors, (Predicate)new Predicate<FeedDescriptor>(){

                public boolean apply(FeedDescriptor input) {
                    return !input.isDefaultRepository();
                }
            }));
            String newValue = FeedDescriptors.feedsToString(feeds);
            this.getPreferenceStore().setValue(this.getPreferenceName(), newValue);
            this.getPreferenceStore().setValue("custom.feed.list.sorted", FeedDescriptors.customFeedsToString(customFeeds));
        }

        public int getNumberOfControls() {
            return 2;
        }

        public List<FeedDescriptor> getValue() {
            List feeds = (List)this.tableViewer.getInput();
            for (FeedDescriptor feed : feeds) {
                feed.setEnabled(this.tableViewer.getChecked((Object)feed));
            }
            return feeds;
        }
    }
}

