/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.constructors;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class ConstructorModel {
    @SerializedName(value="type")
    private ITypeName type;
    @SerializedName(value="calls")
    private Multiset<IMethodName> calls = HashMultiset.create();

    public ConstructorModel() {
    }

    public ConstructorModel(ITypeName type, Map<IMethodName, Integer> callFrequencies) {
        this.type = type;
        for (Map.Entry<IMethodName, Integer> entry : callFrequencies.entrySet()) {
            this.calls.add((Object)entry.getKey(), entry.getValue().intValue());
        }
    }

    public ITypeName getExpectedType() {
        return this.type;
    }

    public int getConstructorCallCount(IMethodName method) {
        return this.calls.count((Object)method);
    }

    public int getConstructorCallTotal() {
        return this.calls.size();
    }

    public Set<IMethodName> getEntries() {
        return this.calls.elementSet();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ConstructorModel that = (ConstructorModel)other;
        return Objects.equals(this.type, that.type) && Objects.equals(this.calls, that.calls);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.calls);
    }
}

