/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.recommenders.internal.rcp.BundleResolutionFailureDialog;
import org.eclipse.recommenders.internal.rcp.CachingAstProvider;
import org.eclipse.recommenders.internal.rcp.JavaElementSelectionService;
import org.eclipse.recommenders.internal.rcp.JavaModelEventsService;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.eclipse.recommenders.internal.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.rcp.l10n.Messages;
import org.eclipse.recommenders.jdt.AstBindings;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.rcp.utils.ASTStringUtils;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class RcpModule
extends AbstractModule {
    protected void configure() {
        this.bind(JavaElementResolver.class).in(Scopes.SINGLETON);
        this.requestStaticInjection(new Class[]{ASTStringUtils.class});
        this.requestStaticInjection(new Class[]{ASTNodeUtils.class});
        this.requestStaticInjection(new Class[]{AstBindings.class});
        this.bind(Helper.class).asEagerSingleton();
        this.bind(SharedImages.class).in(Scopes.SINGLETON);
        this.configureAstProvider();
        this.bindRcpServiceListener();
        this.checkBundleResolution();
    }

    private void configureAstProvider() {
        CachingAstProvider p = new CachingAstProvider();
        JavaCore.addElementChangedListener((IElementChangedListener)p);
        this.bind(IAstProvider.class).toInstance((Object)p);
    }

    private void bindRcpServiceListener() {
        this.bindListener((Matcher)new RcpServiceMatcher(), new Listener());
    }

    @Singleton
    @Provides
    public JavaModelEventsService provideJavaModelEventsProvider(EventBus bus, IWorkspaceRoot workspace) {
        JavaModelEventsService p = new JavaModelEventsService(bus, workspace);
        JavaCore.addElementChangedListener((IElementChangedListener)p);
        return p;
    }

    @Provides
    public IProxyService provideProxyService() {
        return ProxyManager.getProxyManager();
    }

    @Provides
    public IWebBrowser provideWebBrowser(IWorkbench wb) throws PartInitException {
        return wb.getBrowserSupport().getExternalBrowser();
    }

    @Provides
    @Singleton
    public JavaElementSelectionService provideJavaSelectionProvider(EventBus bus) {
        final JavaElementSelectionService provider = new JavaElementSelectionService(bus);
        new UIJob(Messages.JOB_NAME_SELECTION_LISTENER_REGISTRATION){
            {
                super($anonymous0);
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ISelectionService service = (ISelectionService)ww.getService(ISelectionService.class);
                service.addPostSelectionListener((ISelectionListener)provider);
                return Status.OK_STATUS;
            }
        };
        return provider;
    }

    @Provides
    public IWorkspaceRoot provideWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Provides
    public IWorkspace provideWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Provides
    public Display provideDisplay() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        return d;
    }

    @Provides
    public IWorkbench provideWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Provides
    public IWorkbenchPage provideActiveWorkbenchPage(IWorkbench wb) {
        if (this.isRunningInUiThread()) {
            return wb.getActiveWorkbenchWindow().getActivePage();
        }
        return this.runUiFinder().activePage;
    }

    @Provides
    public Shell provideActiveShell(IWorkbench wb) {
        return wb.getActiveWorkbenchWindow().getShell();
    }

    private ActivePageFinder runUiFinder() {
        ActivePageFinder finder = new ActivePageFinder();
        try {
            if (this.isRunningInUiThread()) {
                finder.call();
            } else {
                FutureTask<IWorkbenchPage> task = new FutureTask<IWorkbenchPage>(finder);
                Display.getDefault().asyncExec(task);
                task.get(2L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACTIVE_PAGE_FINDER_TOO_EARLY, (Throwable)e);
        }
        return finder;
    }

    private boolean isRunningInUiThread() {
        return Display.getCurrent() != null;
    }

    @Provides
    public IJavaModel provideJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    @Provides
    public JavaModelManager provideJavaModelManger() {
        return JavaModelManager.getJavaModelManager();
    }

    @Provides
    public IExtensionRegistry provideRegistry() {
        return Platform.getExtensionRegistry();
    }

    private void checkBundleResolution() {
        Bundle[] bundles = RcpPlugin.getDefault().getBundle().getBundleContext().getBundles();
        final ArrayList unresolvedBundles = Lists.newArrayList();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundle.getSymbolicName().startsWith("org.eclipse.recommenders") && bundle.getState() == 2) {
                unresolvedBundles.add(bundle);
            }
            ++n2;
        }
        if (!unresolvedBundles.isEmpty()) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    BundleResolutionFailureDialog dialog = new BundleResolutionFailureDialog(display.getActiveShell(), RcpPlugin.getDefault().getBundle().getVersion(), unresolvedBundles);
                    if (!dialog.isIgnored()) {
                        dialog.open();
                    }
                }
            });
        }
    }

    private static final class ActivePageFinder
    implements Callable<IWorkbenchPage> {
        private IWorkbench workbench;
        private IWorkbenchWindow activeWorkbenchWindow;
        private IWorkbenchPage activePage;

        private ActivePageFinder() {
        }

        @Override
        public IWorkbenchPage call() throws Exception {
            this.workbench = PlatformUI.getWorkbench();
            this.activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            this.activePage = this.activeWorkbenchWindow.getActivePage();
            return this.activePage;
        }
    }

    static class Helper {
        @Inject
        JavaElementSelectionService provider;
        @Inject
        JavaModelEventsService javaModelEventsService;

        Helper() {
        }
    }

    static class Listener
    implements TypeListener {
        Listener() {
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            final Provider provider = encounter.getProvider(EventBus.class);
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(Object i) {
                    this.registerWithEventBus(i);
                    Method[] methodArray = i.getClass().getDeclaredMethods();
                    int n = methodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean hasPreDestroy;
                        Method m = methodArray[n2];
                        boolean hasPostConstruct = m.getAnnotation(PostConstruct.class) != null;
                        boolean bl = hasPreDestroy = m.getAnnotation(PreDestroy.class) != null;
                        if (hasPreDestroy) {
                            this.registerPreDestroyHook(i, m);
                        }
                        if (hasPostConstruct) {
                            this.executeMethod(i, m);
                        }
                        ++n2;
                    }
                }

                private void executeMethod(Object i, Method m) {
                    try {
                        m.setAccessible(true);
                        m.invoke(i, new Object[0]);
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_OCCURRED_IN_SERVICE_HOOK, (Throwable)e, (Object[])new Object[]{m});
                    }
                }

                private void registerPreDestroyHook(final Object i, final Method m) {
                    PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                        public boolean preShutdown(IWorkbench workbench, boolean forced) {
                            return true;
                        }

                        public void postShutdown(IWorkbench workbench) {
                            this.executeMethod(i, m);
                        }
                    });
                }

                private void registerWithEventBus(Object i) {
                    EventBus bus = (EventBus)provider.get();
                    bus.register(i);
                }
            });
        }
    }

    static class RcpServiceMatcher
    extends AbstractMatcher<Object> {
        RcpServiceMatcher() {
        }

        public boolean matches(Object t) {
            if (t instanceof TypeLiteral) {
                Class rawType = ((TypeLiteral)t).getRawType();
                Object[] implemented = rawType.getInterfaces();
                return ArrayUtils.contains((Object[])implemented, IRcpService.class);
            }
            return false;
        }
    }
}

