/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class Uris {
    private Uris() {
    }

    public static String toStringWithMaskedPassword(URI uri, char mask) {
        int indexOfColon;
        if (uri.isOpaque()) {
            return uri.toString();
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null && (indexOfColon = userInfo.indexOf(58)) > 0) {
            userInfo = String.valueOf(userInfo.substring(0, indexOfColon + 1)) + StringUtils.repeat((char)mask, (int)(userInfo.length() - indexOfColon - 1));
        }
        return Uris.toStringWithUserInfo(uri, userInfo);
    }

    public static boolean isPasswordProtected(URI uri) {
        if (uri.isOpaque()) {
            return false;
        }
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            return false;
        }
        int indexOfColon = userInfo.indexOf(58);
        return indexOfColon > 0;
    }

    public static boolean hasCredentials(URI uri) {
        return uri.getUserInfo() != null;
    }

    public static String toStringWithoutUserinfo(URI uri) {
        if (uri.isOpaque()) {
            return uri.toString();
        }
        return Uris.toStringWithUserInfo(uri, null);
    }

    private static String toStringWithUserInfo(URI uri, String userInfo) {
        try {
            URI uriWithServerAuthority = uri.parseServerAuthority();
            return new URI(uriWithServerAuthority.getScheme(), userInfo, uriWithServerAuthority.getHost(), uriWithServerAuthority.getPort(), uriWithServerAuthority.getPath(), uriWithServerAuthority.getQuery(), uriWithServerAuthority.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Optional<URI> parseURI(String uriString) {
        try {
            return Optional.of((Object)new URI(uriString).parseServerAuthority());
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
    }

    public static URI toUri(String uriString) {
        try {
            return new URI(uriString).parseServerAuthority();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean isUriProtocolSupported(URI uri, List<String> protocols) {
        for (String protocol : protocols) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)uri.getScheme())) continue;
            return true;
        }
        return false;
    }

    public static String mangle(URI uri) {
        String string = Uris.toStringWithoutUserinfo(uri);
        return string.replaceAll("\\W", "_");
    }
}

