/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.Map;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IAnnotation;
import org.eclipse.recommenders.utils.names.ITypeName;

@Beta
public class VmAnnotation
implements IAnnotation {
    private static Map<ITypeName, VmAnnotation> index = new MapMaker().weakValues().makeMap();
    private ITypeName annotationType;

    public static synchronized IAnnotation get(ITypeName annotationType) {
        VmAnnotation res = index.get(annotationType);
        if (res == null) {
            res = new VmAnnotation(annotationType);
            index.put(annotationType, res);
        }
        return res;
    }

    @VisibleForTesting
    protected VmAnnotation(ITypeName annotationType) {
        Checks.ensureIsNotNull(annotationType);
        this.annotationType = annotationType;
    }

    @Override
    public ITypeName getAnnotationType() {
        return this.annotationType;
    }

    public String toString() {
        return "@" + this.annotationType.getIdentifier();
    }
}

