/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.rcp.actions;

import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.recommenders.internal.models.rcp.DownloadModelArchiveJob;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.rcp.utils.Jobs;

public class TriggerModelDownloadForModelCoordinatesAction
extends Action {
    private EclipseModelRepository repo;
    private Set<ModelCoordinate> mcs = new HashSet<ModelCoordinate>();
    private EventBus bus;

    public TriggerModelDownloadForModelCoordinatesAction(String text, EclipseModelRepository repo, EventBus bus) {
        super(text);
        this.repo = repo;
        this.bus = bus;
    }

    public TriggerModelDownloadForModelCoordinatesAction(String text, Set<ModelCoordinate> mcs, EclipseModelRepository repo, EventBus bus) {
        this(text, repo, bus);
        this.mcs = mcs;
    }

    public void run() {
        this.triggerDownloadForModelCoordinates(this.mcs);
    }

    public void triggerDownloadForModelCoordinates(Set<ModelCoordinate> mcs) {
        HashSet<DownloadModelArchiveJob> jobs = new HashSet<DownloadModelArchiveJob>();
        for (ModelCoordinate mc : mcs) {
            jobs.add(new DownloadModelArchiveJob(this.repo, mc, false, this.bus));
        }
        Jobs.sequential((String)MessageFormat.format(Messages.JOB_NAME_DOWNLOADING_MODELS, jobs.size()), jobs);
    }
}

