/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyPackageCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocInlineTagCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocLinkTypeCompletionProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableAnonymousTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableFilledArgumentNamesMethodProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableGetterSetterCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaMethodCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavadocInlineTagCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavadocLinkTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyGenericTypeProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyJavaCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyJavaTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyPackageCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableMethodDeclarationCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableOverrideCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableParameterGuessingProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.recommenders.utils.Throws;

public class ProcessableProposalFactory
implements IProcessableProposalFactory {
    private static final String ORG_ECLIPSE_OBJECTTEAMS_OTDT = "org.eclipse.objectteams.otdt";
    private static Class<JavaMethodCompletionProposal> javaMethodCompletionProposalClass;
    private static Class<JavaFieldWithCastedReceiverCompletionProposal> javaFieldWithCastedReceiverCompletionProposalClass;
    private static Class<OverrideCompletionProposal> overrideCompletionProposalClass;
    private static Class<AnonymousTypeCompletionProposal> anonymousTypeCompletionProposalClass;
    private static Class<JavaCompletionProposal> javaCompletionProposalClass;
    private static Class<LazyGenericTypeProposal> lazyGenericTypeProposalClass;
    private static Class<LazyJavaTypeCompletionProposal> lazyJavaTypeCompletionProposalClass;
    private static Class<LazyJavaCompletionProposal> lazyJavaCompletionProposaClass;
    private static Class<FilledArgumentNamesMethodProposal> filledArgumentNamesMethodProposalClass;
    private static Class<ParameterGuessingProposal> parameterGuessingProposalClass;
    private static Class<MethodDeclarationCompletionProposal> methodDeclarationCompletionProposalClass;
    private static Class<LazyPackageCompletionProposal> lazyPackageCompletionProposalClass;
    private static Class<GetterSetterCompletionProposal> getterSetterCompletionProposalClass;
    private static Class<JavadocLinkTypeCompletionProposal> javadocLinkTypeCompletionProposalClass;
    private static Class<JavadocInlineTagCompletionProposal> javadocInlineTagCompletionProposalClass;
    private static Class<? extends LazyJavaCompletionProposal> lazyModuleCompletionProposals;
    private static Method proposalInfoMethod;

    static {
        lazyModuleCompletionProposals = (Class)Reflections.loadClass((boolean)false, (ClassLoader)ProcessableProposalFactory.class.getClassLoader(), (String)"org.eclipse.jdt.internal.ui.text.java.LazyModuleCompletionProposal").orNull();
        proposalInfoMethod = (Method)Reflections.getDeclaredMethod((boolean)true, AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Class[])new Class[0]).orNull();
        try {
            javaMethodCompletionProposalClass = JavaMethodCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javaFieldWithCastedReceiverCompletionProposalClass = JavaFieldWithCastedReceiverCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            overrideCompletionProposalClass = OverrideCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            anonymousTypeCompletionProposalClass = AnonymousTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javaCompletionProposalClass = JavaCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyGenericTypeProposalClass = LazyGenericTypeProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyJavaCompletionProposaClass = LazyJavaCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyJavaTypeCompletionProposalClass = LazyJavaTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            filledArgumentNamesMethodProposalClass = FilledArgumentNamesMethodProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            parameterGuessingProposalClass = ParameterGuessingProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            lazyPackageCompletionProposalClass = LazyPackageCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            getterSetterCompletionProposalClass = GetterSetterCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javadocLinkTypeCompletionProposalClass = JavadocLinkTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
        try {
            javadocInlineTagCompletionProposalClass = JavadocInlineTagCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            ProcessableProposalFactory.logWarning(e);
        }
    }

    private static void logWarning(NoClassDefFoundError e) {
        Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_LOAD_COMPLETION_PROPOSAL_CLASS, (Throwable)e);
    }

    public static IJavaCompletionProposal create(CompletionProposal coreProposal, IJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context, IProcessableProposalFactory factory) {
        Class<?> c = uiProposal.getClass();
        try {
            if (javaMethodCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaMethodCompletionProposal(coreProposal, (JavaMethodCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (javaFieldWithCastedReceiverCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaFieldWithCastedReceiverCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (overrideCompletionProposalClass == c) {
                IProcessableProposal res = factory.newOverrideCompletionProposal(coreProposal, (OverrideCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (anonymousTypeCompletionProposalClass == c) {
                IProcessableProposal res = factory.newAnonymousTypeCompletionProposal(coreProposal, (AnonymousTypeCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (javaCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (lazyGenericTypeProposalClass == c) {
                IProcessableProposal res = factory.newLazyGenericTypeProposal(coreProposal, (LazyGenericTypeProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (lazyJavaTypeCompletionProposalClass == c) {
                IProcessableProposal res = factory.newLazyJavaTypeCompletionProposal(coreProposal, (LazyJavaTypeCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (filledArgumentNamesMethodProposalClass == c) {
                IProcessableProposal res = factory.newFilledArgumentNamesMethodProposal(coreProposal, (FilledArgumentNamesMethodProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (parameterGuessingProposalClass == c) {
                IProcessableProposal res = factory.newParameterGuessingProposal(coreProposal, (ParameterGuessingProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (methodDeclarationCompletionProposalClass == c) {
                IProcessableProposal res = factory.newMethodDeclarationCompletionProposal(coreProposal, (MethodDeclarationCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (lazyPackageCompletionProposalClass == c) {
                IProcessableProposal res = factory.newLazyPackageCompletionProposal(coreProposal, (LazyPackageCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (getterSetterCompletionProposalClass == c) {
                IProcessableProposal res = factory.newGetterSetterCompletionProposal(coreProposal, (GetterSetterCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (javadocLinkTypeCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavadocLinkTypeCompletionProposal(coreProposal, (JavadocLinkTypeCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (javadocInlineTagCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavadocInlineTagCompletionProposal(coreProposal, (JavadocInlineTagCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (lazyJavaCompletionProposaClass == c || lazyModuleCompletionProposals == c) {
                IProcessableProposal res = factory.newLazyJavaCompletionProposal(coreProposal, (LazyJavaCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.copyProposalInfo(uiProposal, res);
                return res;
            }
            if (ProcessableProposalFactory.isWhitelisted(uiProposal, ORG_ECLIPSE_OBJECTTEAMS_OTDT)) {
                return uiProposal;
            }
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_UNEXPECTED_PROPOSAL_KIND, (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_WRAP_JDT_PROPOSAL, (Throwable)e, (Object[])new Object[]{c, uiProposal.getDisplayString()});
            return uiProposal;
        }
    }

    private static boolean isWhitelisted(IJavaCompletionProposal uiProposal, String whitelistedPackage) {
        String uiProposalPackage = uiProposal.getClass().getPackage().getName();
        if (uiProposalPackage.startsWith(whitelistedPackage)) {
            if (uiProposalPackage.length() == whitelistedPackage.length()) {
                return true;
            }
            return uiProposalPackage.charAt(whitelistedPackage.length()) == '.';
        }
        return false;
    }

    private static void copyProposalInfo(IJavaCompletionProposal originalProposal, IProcessableProposal processableProposal) {
        if (Checks.anyIsNull((Object[])new Object[]{proposalInfoMethod, processableProposal, originalProposal})) {
            return;
        }
        try {
            ProposalInfo info = (ProposalInfo)proposalInfoMethod.invoke((Object)originalProposal, new Object[0]);
            processableProposal.setProposalInfo(info);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_SET_PROPOSAL_INFO, (Throwable)e, (Object[])new Object[]{processableProposal});
        }
    }

    @Override
    public IProcessableProposal newLazyGenericTypeProposal(CompletionProposal coreProposal, LazyGenericTypeProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyGenericTypeProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newFilledArgumentNamesMethodProposal(CompletionProposal coreProposal, FilledArgumentNamesMethodProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableFilledArgumentNamesMethodProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newParameterGuessingProposal(CompletionProposal coreProposal, ParameterGuessingProposal uiProposal, JavaContentAssistInvocationContext context) {
        boolean fillBestGuess = this.shouldFillArgumentNames();
        return this.postConstruct(new ProcessableParameterGuessingProposal(coreProposal, context, fillBestGuess), (AbstractJavaCompletionProposal)uiProposal);
    }

    private boolean shouldFillArgumentNames() {
        try {
            boolean res = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_guess_method_arguments");
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public IProcessableProposal newAnonymousTypeCompletionProposal(CompletionProposal coreProposal, AnonymousTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        return this.postConstruct(new ProcessableAnonymousTypeCompletionProposal(coreProposal, uiProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavaFieldWithCastedReceiverCompletionProposal(CompletionProposal coreProposal, JavaFieldWithCastedReceiverCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context), (AbstractJavaCompletionProposal)uiProposal);
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavaCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaCompletionProposal(coreProposal, uiProposal, context), (AbstractJavaCompletionProposal)uiProposal);
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavadocLinkTypeCompletionProposal(CompletionProposal coreProposal, JavadocLinkTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableJavadocLinkTypeCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavadocInlineTagCompletionProposal(CompletionProposal coreProposal, JavadocInlineTagCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableJavadocInlineTagCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newJavaMethodCompletionProposal(CompletionProposal coreProposal, JavaMethodCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableJavaMethodCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newLazyJavaTypeCompletionProposal(CompletionProposal coreProposal, LazyJavaTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyJavaTypeCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newOverrideCompletionProposal(CompletionProposal coreProposal, OverrideCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableOverrideCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newMethodDeclarationCompletionProposal(CompletionProposal coreProposal, MethodDeclarationCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IJavaElement enclosingElement = context.getCoreContext().getEnclosingElement();
            IType type = null;
            if (enclosingElement instanceof IType) {
                type = (IType)enclosingElement;
            } else if (enclosingElement instanceof IMember) {
                type = ((IMember)enclosingElement).getDeclaringType();
            }
            if (type == null) {
                throw Throws.throwIllegalArgumentException((String)"No type found for enclosing element %s", (Object[])new Object[]{enclosingElement});
            }
            return this.postConstruct(ProcessableMethodDeclarationCompletionProposal.newProposal(coreProposal, type, uiProposal.getRelevance()), (AbstractJavaCompletionProposal)uiProposal);
        }
        catch (CoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newGetterSetterCompletionProposal(CompletionProposal coreProposal, GetterSetterCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IField field = (IField)uiProposal.getJavaElement();
            return this.postConstruct(new ProcessableGetterSetterCompletionProposal(coreProposal, field, StringUtils.startsWithAny((CharSequence)uiProposal.getDisplayString(), (CharSequence[])new CharSequence[]{"get", "is"}), uiProposal.getRelevance()), (AbstractJavaCompletionProposal)uiProposal);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newLazyPackageCompletionProposal(CompletionProposal coreProposal, LazyPackageCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyPackageCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    @Override
    public IProcessableProposal newLazyJavaCompletionProposal(CompletionProposal coreProposal, LazyJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyJavaCompletionProposal(coreProposal, context), (AbstractJavaCompletionProposal)uiProposal);
    }

    protected <T extends AbstractJavaCompletionProposal> T postConstruct(T processableProposal, AbstractJavaCompletionProposal originalProposal) {
        ((IProcessableProposal)processableProposal).setProposalProcessorManager(new ProposalProcessorManager((IProcessableProposal)processableProposal));
        processableProposal.setTriggerCharacters(originalProposal.getTriggerCharacters());
        return processableProposal;
    }
}

