/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.preferences;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.recommenders.internal.news.rcp.CommonImages;
import org.eclipse.recommenders.internal.news.rcp.Constants;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeedDialog
extends TitleAreaDialog {
    @VisibleForTesting
    static final List<String> ACCEPTED_PROTOCOLS = ImmutableList.of((Object)"http", (Object)"https");
    private final List<FeedDescriptor> existingDescriptors;
    private FeedDescriptor feed;
    private Text nameValue;
    private Text urlValue;
    private Text pollingIntervalValue;

    public FeedDialog(Shell parentShell, List<FeedDescriptor> existingDescriptors) {
        this(parentShell, null, existingDescriptors);
    }

    public FeedDialog(Shell parentShell, FeedDescriptor feed, List<FeedDescriptor> existingDescriptors) {
        super(parentShell);
        this.feed = feed;
        this.existingDescriptors = existingDescriptors;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.feed != null) {
            newShell.setText(Messages.FEED_DIALOG_TITLE_EDIT);
        } else {
            newShell.setText(Messages.FEED_DIALOG_TITLE_NEW);
        }
    }

    public void create() {
        super.create();
        if (this.feed != null) {
            this.setTitle(Messages.FEED_DIALOG_TITLE_EDIT);
        } else {
            this.setTitle(Messages.FEED_DIALOG_TITLE_NEW);
        }
        this.setMessage(Messages.FEED_DIALOG_DESCRIPTION);
        this.setHelpAvailable(false);
        this.setTitleImage(CommonImages.RSS_DIALOG_TITLE.createImage());
        super.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createFeed(container);
        Dialog.applyDialogFont((Control)area);
        return area;
    }

    private void createFeed(Composite container) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        String nameInputValue = "";
        String urlInputValue = "";
        String pollingIntervalInputValue = String.valueOf(Constants.DEFAULT_POLLING_INTERVAL);
        if (this.feed != null) {
            nameInputValue = this.feed.getName();
            urlInputValue = this.feed.getUri().toString();
            pollingIntervalInputValue = Long.toString(this.feed.getPollingInterval());
        }
        this.nameValue = this.createLabelInputFieldPair(container, gridData, this.nameValue, Messages.FIELD_LABEL_FEED_NAME, nameInputValue);
        this.urlValue = this.createLabelInputFieldPair(container, gridData, this.urlValue, Messages.FIELD_LABEL_URL, urlInputValue);
        this.pollingIntervalValue = this.createLabelInputFieldPair(container, gridData, this.pollingIntervalValue, Messages.FIELD_LABEL_POLLING_INTERVAL, pollingIntervalInputValue);
        this.pollingIntervalValue.setTextLimit(4);
        this.addModifyListeners(this.nameValue, this.urlValue, this.pollingIntervalValue);
    }

    private Text createLabelInputFieldPair(Composite container, GridData gridData, Text text, String labelText, String inputValue) {
        Label label = new Label(container, 0);
        label.setText(labelText);
        text = new Text(container, 2048);
        text.setText(inputValue);
        text.setLayoutData((Object)gridData);
        return text;
    }

    private void addModifyListeners(Text ... texts) {
        ModifyListener validateDialog = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeedDialog.this.updateDialog();
            }
        };
        Text[] textArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            Text text = textArray[n2];
            text.addModifyListener(validateDialog);
            ++n2;
        }
    }

    protected boolean isResizable() {
        return false;
    }

    protected void okPressed() {
        this.feed = new FeedDescriptor(this.urlValue.getText(), this.nameValue.getText(), (Long)FeedDialog.parsePollingIntervalQuietly(this.pollingIntervalValue.getText()).or((Object)0L));
        super.okPressed();
    }

    public FeedDescriptor getFeed() {
        return this.feed;
    }

    private void updateDialog() {
        this.setErrorMessage(FeedDialog.validateFeedDialog(this.feed, this.nameValue.getText(), this.urlValue.getText(), this.pollingIntervalValue.getText(), this.existingDescriptors));
        if (this.getErrorMessage() == null) {
            super.getButton(0).setEnabled(true);
        } else {
            super.getButton(0).setEnabled(false);
        }
    }

    @VisibleForTesting
    static String validateFeedDialog(FeedDescriptor currentFeed, String name, String url, String pollingInterval, List<FeedDescriptor> existingDescriptors) {
        FeedDescriptor duplicateFeed = (FeedDescriptor)FeedDialog.getFeedWithDuplicateUrl(url, currentFeed, existingDescriptors).orNull();
        URI feedUri = (URI)FeedDialog.parseUriQuietly(url).orNull();
        if (Strings.isNullOrEmpty((String)name)) {
            return Messages.FEED_DIALOG_ERROR_EMPTY_NAME;
        }
        if (Strings.isNullOrEmpty((String)url)) {
            return Messages.FEED_DIALOG_ERROR_EMPTY_URL;
        }
        if (feedUri == null || !feedUri.isAbsolute()) {
            return Messages.FEED_DIALOG_ERROR_INVALID_URL;
        }
        if (!FeedDialog.isUriProtocolSupported(feedUri, ACCEPTED_PROTOCOLS)) {
            return MessageFormat.format(Messages.FEED_DIALOG_ERROR_PROTOCOL_UNSUPPORTED, url, Joiner.on((String)", ").join(ACCEPTED_PROTOCOLS));
        }
        if (duplicateFeed != null) {
            return MessageFormat.format(Messages.FEED_DIALOG_ERROR_DUPLICATE_FEED, duplicateFeed.getName());
        }
        if (!FeedDialog.parsePollingIntervalQuietly(pollingInterval).isPresent()) {
            return Messages.FEED_DIALOG_ERROR_POLLING_INTERVAL_INVALID;
        }
        return null;
    }

    private static Optional<URI> parseUriQuietly(String uriString) {
        try {
            return Optional.of((Object)new URI(uriString));
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
    }

    private static Optional<Long> parsePollingIntervalQuietly(String longString) {
        try {
            long pollingInterval = Long.parseLong(longString);
            if (pollingInterval > 0L) {
                return Optional.of((Object)pollingInterval);
            }
            return Optional.absent();
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.absent();
        }
    }

    private static boolean isUriProtocolSupported(URI uri, List<String> protocols) {
        if (uri == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (!protocol.equalsIgnoreCase(uri.getScheme()) && !protocol.equalsIgnoreCase(uri.toString())) continue;
            return true;
        }
        return false;
    }

    private static Optional<FeedDescriptor> getFeedWithDuplicateUrl(String url, FeedDescriptor feed, List<FeedDescriptor> descriptors) {
        for (FeedDescriptor compare : descriptors) {
            if (feed == compare || !url.equals(compare.getUri().toString())) continue;
            return Optional.of((Object)compare);
        }
        return Optional.absent();
    }
}

