/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.overrides.rcp;

import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.recommenders.completion.rcp.IProposalNameProvider;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.overrides.rcp.OverridesRcpPreferences;
import org.eclipse.recommenders.internal.overrides.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.overrides.rcp.l10n.Messages;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.IOverrideModelProvider;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ProposalMatcher;
import org.eclipse.recommenders.utils.names.VmMethodName;

public class OverrideCompletionSessionProcessor
extends SessionProcessor {
    private final Provider<IProjectCoordinateProvider> pcProvider;
    private final Provider<IOverrideModelProvider> modelProvider;
    private final IProposalNameProvider methodNameProvider;
    private final JavaElementResolver jdtCache;
    private final OverridesRcpPreferences prefs;
    private final OverlayImageProposalProcessor overlayProcessor;
    private IRecommendersCompletionContext ctx;
    private IType enclosingType;
    private IType supertype;
    private ProjectCoordinate pc;
    private IOverrideModel model;
    private List<Recommendation<IMethodName>> recommendations;

    @Inject
    public OverrideCompletionSessionProcessor(Provider<IProjectCoordinateProvider> pcProvider, Provider<IOverrideModelProvider> modelProvider, IProposalNameProvider methodNameProvider, JavaElementResolver cache, SharedImages images, OverridesRcpPreferences prefs) {
        this.pcProvider = pcProvider;
        this.modelProvider = modelProvider;
        this.methodNameProvider = methodNameProvider;
        this.jdtCache = cache;
        this.prefs = prefs;
        this.overlayProcessor = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        this.recommendations = null;
        this.ctx = context;
        if (this.isSupportedCompletionType() && this.findEnclosingType() && this.findSuperclass() && this.findProjectCoordinate() && this.hasModel()) {
            try {
                this.computeRecommendations();
                return true;
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_COMPUTE_OVERRIDE_RECOMMENDATIONS, (Throwable)e);
            }
            finally {
                this.releaseModel();
            }
        }
        return false;
    }

    private boolean isSupportedCompletionType() {
        ASTNode completionNode = (ASTNode)this.ctx.getCompletionNode().orNull();
        return completionNode != null && completionNode.getClass() == CompletionOnFieldType.class;
    }

    private boolean findEnclosingType() {
        this.enclosingType = (IType)this.ctx.getEnclosingType().orNull();
        return this.enclosingType != null;
    }

    private boolean findSuperclass() {
        this.supertype = (IType)JdtUtils.findSuperclass((IType)this.enclosingType).orNull();
        return this.supertype != null;
    }

    private boolean findProjectCoordinate() {
        this.pc = (ProjectCoordinate)((IProjectCoordinateProvider)this.pcProvider.get()).resolve(this.supertype).orNull();
        return this.pc != null;
    }

    private boolean hasModel() {
        UniqueTypeName name = new UniqueTypeName(this.pc, this.jdtCache.toRecType(this.supertype));
        this.model = (IOverrideModel)((IOverrideModelProvider)this.modelProvider.get()).acquireModel((IUniqueName)name).orNull();
        return this.model != null;
    }

    private void releaseModel() {
        if (this.model != null) {
            ((IOverrideModelProvider)this.modelProvider.get()).releaseModel((Object)this.model);
        }
    }

    private void computeRecommendations() throws JavaModelException {
        IMethod[] iMethodArray = this.enclosingType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            IMethod superMethod = (IMethod)JdtUtils.findOverriddenMethod((IMethod)m).orNull();
            if (superMethod != null) {
                IMethodName recSuperMethod = (IMethodName)this.jdtCache.toRecMethod(superMethod).or((Object)VmMethodName.NULL);
                this.model.setObservedMethod(recSuperMethod);
            }
            ++n2;
        }
        this.recommendations = Recommendations.top((Iterable)this.model.recommendOverrides(), (int)this.prefs.maxNumberOfProposals, (double)((double)this.prefs.minProposalPercentage / 100.0));
    }

    public void process(IProcessableProposal proposal) throws Exception {
        if (this.recommendations == null || this.recommendations.isEmpty()) {
            return;
        }
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().orNull();
        if (coreProposal == null) {
            return;
        }
        if (coreProposal.getKind() != 7) {
            return;
        }
        IMethodName proposedMethod = (IMethodName)this.methodNameProvider.toMethodName(coreProposal).orNull();
        if (proposedMethod == null) {
            return;
        }
        ProposalMatcher matcher = new ProposalMatcher(proposedMethod);
        for (Recommendation<IMethodName> recommendation : this.recommendations) {
            String label;
            IMethodName recommendedMethod = (IMethodName)recommendation.getProposal();
            if (!matcher.match(recommendedMethod)) continue;
            int boost = this.prefs.changeProposalRelevance ? 1000 + Recommendations.asPercentage(recommendation) : 0;
            String string = label = this.prefs.decorateProposalText ? MessageFormat.format(Messages.PROPOSAL_LABEL_PERCENTAGE, recommendation.getRelevance()) : "";
            if (boost > 0) {
                proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)Recommendations.asPercentage(recommendation));
            }
            ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
            mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(boost, label));
            if (!this.prefs.decorateProposalIcon) break;
            mgr.addProcessor((ProposalProcessor)this.overlayProcessor);
            break;
        }
    }
}

