/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.rcp.completion;

import java.util.Objects;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;

public final class SimpleProposalProcessorMatcher
extends ArgumentMatcher<SimpleProposalProcessor> {
    private final int boost;
    private final String label;

    public SimpleProposalProcessorMatcher(Integer boost, String label) {
        this.boost = boost;
        this.label = label;
    }

    public static SimpleProposalProcessor processorWithBoost(int boost) {
        return (SimpleProposalProcessor)Matchers.argThat((Matcher)new SimpleProposalProcessorMatcher(boost, null));
    }

    public static SimpleProposalProcessor processorWithBoostAndLabel(int boost, String label) {
        return (SimpleProposalProcessor)Matchers.argThat((Matcher)new SimpleProposalProcessorMatcher(boost, label));
    }

    public boolean matches(Object argument) {
        if (!(argument instanceof SimpleProposalProcessor)) {
            return false;
        }
        SimpleProposalProcessor processor = (SimpleProposalProcessor)argument;
        return this.boost == processor.getIncrement() && Objects.equals(this.label, processor.getAddon());
    }

    public void describeTo(Description description) {
        description.appendText("Simple proposal processor: '").appendValue((Object)this.label).appendText("' -> ").appendValue((Object)this.boost);
    }
}

