/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import java.util.Map;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public final class SourceCodeArea
extends JavaSourceViewer {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final IPreferenceStore STORE = JavaPlugin.getDefault().getCombinedPreferenceStore();
    private static final IColorManager COLOR_MANAGER = JavaPlugin.getDefault().getJavaTextTools().getColorManager();
    private static final JavaSourceViewerConfiguration CONFIGURATION = new JavaSourceViewerConfiguration(COLOR_MANAGER, STORE, null, "___java_partitioning");
    private static final Map<String, Object> OPTIONS = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
    private static final CodeFormatter FORMATTER;

    static {
        OPTIONS.put("org.eclipse.jdt.core.formatter.lineSplit", "120");
        FORMATTER = ToolFactory.createCodeFormatter(OPTIONS);
    }

    public SourceCodeArea(Composite parent) {
        super(parent, null, null, false, 72, STORE);
        this.configure((SourceViewerConfiguration)CONFIGURATION);
        this.getTextWidget().setFont(ApidocsViewUtils.CODEFONT);
        this.setEditable(false);
        this.getTextWidget().setLayoutData((Object)GridDataFactory.fillDefaults().indent(20, 0).create());
    }

    public void setCode(String code) {
        Document document = new Document(code);
        SourceCodeArea.format((IDocument)document);
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        textTools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.setInput(document);
    }

    private static void format(IDocument document) {
        int length;
        String sourceCode = document.get();
        TextEdit edit = FORMATTER.format(2, sourceCode, 0, length = document.getLength(), 0, LINE_SEPARATOR);
        if (edit != null) {
            SourceCodeArea.applyTextFormattings(document, edit);
        }
    }

    private static void applyTextFormattings(IDocument document, TextEdit edit) {
        try {
            edit.apply(document);
        }
        catch (MalformedTreeException e) {
            throw new IllegalStateException(e);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e);
        }
    }
}

