/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.transformation;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.linear.MatrixUtils;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.transformation.AbstractDecomposition;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class SmoothedFactorDecomposition
extends AbstractDecomposition {
    @Override
    protected double[] toLatentSpace(double[] v, List<double[]> best) {
        double min = Doubles.min((double[])v);
        double[] latent = new double[v.length + 1];
        latent[0] = min;
        double[] h = new double[v.length];
        Arrays.fill(h, min);
        MathUtils.secureSubtract((double[])v, (double[])h, (double[])h);
        System.arraycopy(h, 0, latent, 1, h.length);
        return latent;
    }

    @Override
    protected List<double[]> getBasis(AbstractFactor f, List<double[]> vectors) {
        ArrayList<double[]> basis = new ArrayList<double[]>();
        int d = MathUtils.product((int[])f.getDimensions()) / vectors.size();
        double[] ones = new double[d];
        Arrays.fill(ones, 1.0);
        basis.add(ones);
        double[][] dArray = MatrixUtils.createRealIdentityMatrix((int)d).getData();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double[] e = dArray[n2];
            basis.add(e);
            ++n2;
        }
        return basis;
    }
}

