/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class ProposalMatcher {
    private String jSignature;
    private String[] jParams;
    private String jName;
    private String rName;
    private ITypeName[] rParams;
    private static Field fOriginalSignature;

    static {
        try {
            fOriginalSignature = InternalCompletionProposal.class.getDeclaredField("originalSignature");
            fOriginalSignature.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    private static boolean canUseReflection(CompletionProposal proposal) {
        return proposal instanceof InternalCompletionProposal && fOriginalSignature != null && fOriginalSignature.isAccessible();
    }

    public ProposalMatcher(CompletionProposal proposal) {
        this.jSignature = this.getSignature(proposal);
        this.jName = String.valueOf(proposal.getName());
        this.jParams = Signature.getParameterTypes((String)this.jSignature);
        int i = 0;
        while (i < this.jParams.length) {
            String param = Signature.getTypeErasure((String)this.jParams[i]);
            String paramBaseType = Signature.getElementType((String)param);
            param = param.replace('.', '/');
            param = StringUtils.removeEnd((String)param, (String)";");
            if (this.isWildcardCapture(paramBaseType) || this.isTypeParameter(paramBaseType)) {
                int dimensions = Signature.getArrayCount((String)param);
                param = String.valueOf(StringUtils.repeat((char)'[', (int)dimensions)) + VmTypeName.OBJECT.getIdentifier();
            }
            this.jParams[i] = param;
            ++i;
        }
    }

    private boolean isWildcardCapture(String param) {
        return param.charAt(0) == '!';
    }

    private boolean isTypeParameter(String param) {
        return param.charAt(0) == 'T';
    }

    private String getSignature(CompletionProposal proposal) {
        try {
            char[] s;
            if (ProposalMatcher.canUseReflection(proposal) && (s = (char[])fOriginalSignature.get(proposal)) != null) {
                return String.valueOf(s);
            }
        }
        catch (Exception exception) {}
        return String.valueOf(proposal.getSignature());
    }

    public boolean match(IMethodName rMethod) {
        this.rName = rMethod.getName();
        this.rParams = rMethod.getParameterTypes();
        if (!this.sameName()) {
            return false;
        }
        if (!this.sameNumberOfParameters()) {
            return false;
        }
        int i = this.jParams.length;
        while (i-- > 0) {
            if (this.sameParameterType(i)) continue;
            return false;
        }
        return true;
    }

    private boolean sameParameterType(int i) {
        return this.jParams[i].equals(this.rParams[i].getIdentifier());
    }

    private boolean sameNumberOfParameters() {
        return this.jParams.length == this.rParams.length;
    }

    private boolean sameName() {
        return this.jName.equals(this.rName);
    }
}

