/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.utils.Checks;

public class ProcessableLazyJavaTypeCompletionProposal
extends LazyJavaTypeCompletionProposal
implements IProcessableProposal {
    private Map<IProposalTag, Object> tags = Maps.newHashMap();
    private ProposalProcessorManager mgr;
    private CompletionProposal coreProposal;
    private String lastPrefix;

    protected ProcessableLazyJavaTypeCompletionProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        super(coreProposal, context);
    }

    public boolean isPrefix(String prefix, String completion) {
        this.lastPrefix = prefix;
        if (this.mgr.prefixChanged(prefix)) {
            return true;
        }
        return super.isPrefix(prefix, completion);
    }

    @Override
    public String getPrefix() {
        return this.lastPrefix;
    }

    @Override
    public Optional<CompletionProposal> getCoreProposal() {
        return Optional.fromNullable((Object)this.coreProposal);
    }

    @Override
    public ProposalProcessorManager getProposalProcessorManager() {
        return this.mgr;
    }

    @Override
    public void setProposalProcessorManager(ProposalProcessorManager mgr) {
        this.mgr = mgr;
    }

    @Override
    public void setTag(IProposalTag key, Object value) {
        Checks.ensureIsNotNull((Object)key);
        if (value == null) {
            this.tags.remove(key);
        } else {
            this.tags.put(key, value);
        }
    }

    @Override
    public <T> Optional<T> getTag(IProposalTag key) {
        return Optional.fromNullable((Object)this.tags.get(key));
    }

    @Override
    public <T> T getTag(IProposalTag key, T defaultValue) {
        Object res = this.tags.get(key);
        return (T)(res != null ? res : defaultValue);
    }
}

