/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.base.Preconditions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PreferenceLinkDialog
extends MessageDialog {
    private final String linkText;
    private final String preferencePageId;

    public PreferenceLinkDialog(Shell parent, String title, Image titleImage, String message, int imageType, String[] buttonLabels, int defaultIndex, String linkText, String preferencePageId) {
        super(parent, title, titleImage, message, imageType, buttonLabels, defaultIndex);
        Preconditions.checkNotNull((Object)linkText);
        Preconditions.checkNotNull((Object)preferencePageId);
        this.linkText = linkText;
        this.preferencePageId = preferencePageId;
    }

    protected Control createCustomArea(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(this.linkText);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceLinkDialog.this.cancelPressed();
                PreferencesUtil.createPreferenceDialogOn((Shell)PreferenceLinkDialog.this.getShell(), (String)PreferenceLinkDialog.this.preferencePageId, null, null).open();
            }
        });
        link.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.getMinimumMessageWidth(), -1).create());
        return link;
    }
}

