/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class MethodDeclarationFinder {
    private final Set<MethodDeclaration> matches = Sets.newHashSet();

    public static Set<MethodDeclaration> find(CompilationUnit cu, Set<IMethodName> methods) {
        return new MethodDeclarationFinder(cu, methods).getMatches();
    }

    public static Optional<MethodDeclaration> find(CompilationUnit cu, IMethodName method) {
        return new MethodDeclarationFinder(cu, Collections.singleton(method)).getMatch();
    }

    public boolean matches() {
        return !this.matches.isEmpty();
    }

    public Optional<MethodDeclaration> getMatch() {
        return Optional.fromNullable((Object)((MethodDeclaration)Iterables.getFirst(this.matches, null)));
    }

    public Set<MethodDeclaration> getMatches() {
        return this.matches;
    }

    public MethodDeclarationFinder(CompilationUnit cuNode, final Set<IMethodName> searchedMethodes) {
        cuNode.accept(new ASTVisitor(false){

            public boolean visit(MethodDeclaration node) {
                for (IMethodName searchedMethod : searchedMethodes) {
                    ITypeName[] crParams;
                    List jdtParams;
                    if (!ASTNodeUtils.sameSimpleName(node, searchedMethod) && (!searchedMethod.isInit() || !searchedMethod.isInit()) || !ASTNodeUtils.haveSameNumberOfParameters(jdtParams = node.parameters(), crParams = searchedMethod.getParameterTypes()) || !ASTNodeUtils.haveSameParameterTypes(jdtParams, crParams)) continue;
                    MethodDeclarationFinder.this.matches.add(node);
                    break;
                }
                return true;
            }
        });
    }
}

