/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SnipmatchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringButtonFieldEditor snippetsRepoField;

    public SnipmatchPreferencePage() {
        super(1);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
    }

    public void createFieldEditors() {
        this.snippetsRepoField = new StringButtonFieldEditor("snippets.repo.url", Messages.PREFPAGE_LABEL_REMOTE_SNIPPETS_REPOSITORY, this.getFieldEditorParent()){

            protected String changePressed() {
                String url = this.getPreferenceStore().getDefaultString("snippets.repo.url");
                InputDialog d = new InputDialog(this.getShell(), Messages.DIALOG_TITLE_NEW_SNIPPET_REPOSITORY, Messages.DIALOG_MESSAGE_NEW_SNIPPET_REPOSITORY, url, (IInputValidator)new UriInputValidator());
                if (d.open() == 0) {
                    return d.getValue();
                }
                return null;
            }
        };
        this.addField((FieldEditor)this.snippetsRepoField);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.snipmatch.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    private final class UriInputValidator
    implements IInputValidator {
        private UriInputValidator() {
        }

        public String isValid(String newText) {
            try {
                new URI(newText);
                return null;
            }
            catch (URISyntaxException e) {
                return e.getMessage();
            }
        }
    }
}

