/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.base.Joiner;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.recommenders.internal.chain.rcp.ChainRcpPlugin;
import org.eclipse.recommenders.internal.chain.rcp.Messages;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ChainsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_MAX_CHAINS = "recommenders.chain.max_chains";
    public static final String PREF_MIN_CHAIN_LENGTH = "recommenders.chain.min_chain_length";
    public static final String PREF_MAX_CHAIN_LENGTH = "recommenders.chain.max_chain_length";
    public static final String PREF_TIMEOUT = "recommenders.chain.timeout";
    public static final String PREF_IGNORED_TYPES = "recommenders.chain.ignore_types";
    public static final char IGNORE_TYPES_SEPARATOR = '|';

    public ChainsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_CHAINS);
        this.setPreferenceStore(ChainRcpPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField(PREF_MAX_CHAINS, Messages.FIELD_LABEL_MAX_CHAINS, 1, 99);
        this.addField(PREF_MIN_CHAIN_LENGTH, Messages.FIELD_LABEL_MIN_CHAIN_LENGTH, 1, 10);
        this.addField(PREF_MAX_CHAIN_LENGTH, Messages.FIELD_LABEL_MAX_CHAIN_LENGTH, 1, 10);
        this.addField(PREF_TIMEOUT, Messages.FIELD_LABEL_TIMEOUT, 1, 99);
        this.addField((FieldEditor)new IgnoredTypesEditor(Messages.FIELD_LABEL_IGNORED_TYPES, this.getFieldEditorParent()));
        this.addText(Messages.PREFPAGE_FOOTER_IGNORED_TYPES_WARNING);
    }

    private void addField(String name, String labeltext, int min, int max) {
        IntegerFieldEditor field = new IntegerFieldEditor(name, labeltext, this.getFieldEditorParent());
        field.setValidRange(min, max);
        this.addField((FieldEditor)field);
    }

    private void addText(String text) {
        Label label = new Label(this.getFieldEditorParent(), 64);
        label.setText(text);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
    }

    private static final class IgnoredTypesEditor
    extends ListEditor {
        IgnoredTypesEditor(String label, Composite parent) {
            super(ChainsPreferencePage.PREF_IGNORED_TYPES, label, parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
        }

        protected String[] parseString(String stringList) {
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            return stringList.split("\\|");
        }

        protected String getNewInputObject() {
            SelectionDialog dialog;
            block3: {
                try {
                    dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false);
                    if (dialog.open() != 1) break block3;
                    return null;
                }
                catch (JavaModelException e) {
                    Throws.throwIllegalArgumentException((String)e.getMessage());
                    return null;
                }
            }
            return ((IType)dialog.getResult()[0]).getFullyQualifiedName();
        }

        protected String createList(String[] items) {
            return Joiner.on((char)'|').join((Object[])items);
        }
    }
}

