/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.swt.widgets.Shell;

public final class Dialogs {
    private Dialogs() {
    }

    public static InputDialog newModelRepositoryUrlDialog(Shell parent, final String[] remoteUrls) {
        return new InputDialog(parent, Messages.DIALOG_TITLE_ADD_MODEL_REPOSITORY, Messages.FIELD_LABEL_REPOSITORY_URI, "http://download.eclipse.org/recommenders/models/<version>", new IInputValidator(){

            public String isValid(String newText) {
                if (this.isURIAlreadyAdded(newText)) {
                    return Messages.DIALOG_MESSAGE_URI_ALREADY_ADDED;
                }
                if (this.isInvalidRepoURI(newText)) {
                    return Messages.DIALOG_MESSAGE_INVALID_REPOSITORY_URI;
                }
                return null;
            }

            private boolean isURIAlreadyAdded(String newText) {
                HashSet items = Sets.newHashSet((Object[])remoteUrls);
                return items.contains(newText);
            }

            private boolean isInvalidRepoURI(String uri) {
                try {
                    new URI(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return true;
                }
                return false;
            }
        });
    }
}

