/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.recommenders.internal.rcp.Messages;
import org.eclipse.recommenders.rcp.JavaModelEvents;
import org.eclipse.recommenders.utils.Checks;

public class JavaModelEventsService
implements IElementChangedListener {
    private final EventBus bus;
    private final IWorkspaceRoot workspace;

    @Inject
    public JavaModelEventsService(EventBus bus, IWorkspaceRoot workspace) {
        this.bus = bus;
        this.workspace = workspace;
        this.simulateProjectOpenEvents();
    }

    private void simulateProjectOpenEvents() {
        new SimulateOpenJavaProjectsJob(Messages.JOB_INITIALIZE_PROJECTS).schedule();
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.process(delta);
    }

    private void process(IJavaElementDelta delta) {
        if (this.isChildAffectedByChange(delta)) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.process(child);
                ++n2;
            }
        }
        if (this.isProjectChangedEvent(delta)) {
            this.processProjectChangedEvent(delta);
        } else if (this.isCompilationUnitChangedEvent(delta)) {
            this.processCompilationUnitChangedEvent(delta);
        } else if (this.isJarPackageFragementRootChangedEvent(delta)) {
            this.processJarPackageFragementRootChangedEvent(delta);
        }
    }

    private boolean isChildAffectedByChange(IJavaElementDelta delta) {
        return (delta.getFlags() & 8) != 0;
    }

    private boolean isProjectChangedEvent(IJavaElementDelta delta) {
        IJavaElement changedElement = delta.getElement();
        IJavaProject javaProject = delta.getElement().getJavaProject();
        return javaProject != null && changedElement == javaProject;
    }

    private void processProjectChangedEvent(IJavaElementDelta delta) {
        IJavaProject javaProject = (IJavaProject)Checks.cast((Object)delta.getElement());
        if (this.isProjectOpenedEvent(delta)) {
            this.fireProjectOpenedEvent(javaProject);
        } else if (this.isProjectClosedEvent(delta)) {
            this.fireProjectClosedEvent(javaProject);
        }
    }

    private boolean isProjectOpenedEvent(IJavaElementDelta delta) {
        boolean opened;
        boolean added = (delta.getKind() & 1) != 0;
        boolean bl = opened = (delta.getFlags() & 0x200) != 0;
        return added || opened;
    }

    private void fireProjectOpenedEvent(IJavaProject javaProject) {
        this.bus.post((Object)new JavaModelEvents.JavaProjectOpened(javaProject));
    }

    private boolean isProjectClosedEvent(IJavaElementDelta delta) {
        boolean closed;
        boolean removed = (delta.getKind() & 2) != 0;
        boolean bl = closed = (delta.getFlags() & 0x400) != 0;
        return removed || closed;
    }

    private void fireProjectClosedEvent(IJavaProject javaProject) {
        this.bus.post((Object)new JavaModelEvents.JavaProjectClosed(javaProject));
    }

    private boolean isCompilationUnitChangedEvent(IJavaElementDelta delta) {
        return delta.getElement() instanceof ICompilationUnit;
    }

    private void processCompilationUnitChangedEvent(IJavaElementDelta delta) {
        ICompilationUnit cu = (ICompilationUnit)Checks.cast((Object)delta.getElement());
        switch (delta.getKind()) {
            case 1: {
                this.fireCompilationUnitAddedEvent(cu);
                break;
            }
            case 4: {
                if (this.isCompilationUnitSavedEvent(delta)) {
                    this.fireCompilationUnitSavedEvent(cu);
                    break;
                }
                this.fireCompilationUnitChangedEvent(cu);
                break;
            }
            case 2: {
                this.fireCompilationUnitRemovedEvent(cu);
            }
        }
    }

    private void fireCompilationUnitAddedEvent(ICompilationUnit cu) {
        this.bus.post((Object)new JavaModelEvents.CompilationUnitAdded(cu));
    }

    private boolean isCompilationUnitSavedEvent(IJavaElementDelta delta) {
        int flags = delta.getFlags() & 0x40000;
        return flags > 0;
    }

    private void fireCompilationUnitSavedEvent(ICompilationUnit cu) {
        this.bus.post((Object)new JavaModelEvents.CompilationUnitSaved(cu));
    }

    private void fireCompilationUnitChangedEvent(ICompilationUnit cu) {
        this.bus.post((Object)new JavaModelEvents.CompilationUnitChanged(cu));
    }

    private void fireCompilationUnitRemovedEvent(ICompilationUnit cu) {
        this.bus.post((Object)new JavaModelEvents.CompilationUnitRemoved(cu));
    }

    private boolean isJarPackageFragementRootChangedEvent(IJavaElementDelta delta) {
        return delta.getElement() instanceof JarPackageFragmentRoot;
    }

    private void processJarPackageFragementRootChangedEvent(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                this.fireJarPackageFragementRootAddedEvent(delta);
                return;
            }
            case 2: {
                this.fireJarPackageFragementRootRemoved(delta);
                return;
            }
            case 4: {
                switch (delta.getFlags()) {
                    case 64: {
                        this.fireJarPackageFragementRootAddedEvent(delta);
                        return;
                    }
                    case 128: {
                        this.fireJarPackageFragementRootRemoved(delta);
                        return;
                    }
                }
            }
        }
    }

    private void fireJarPackageFragementRootAddedEvent(IJavaElementDelta delta) {
        this.bus.post((Object)new JavaModelEvents.JarPackageFragmentRootAdded((JarPackageFragmentRoot)delta.getElement()));
    }

    private void fireJarPackageFragementRootRemoved(IJavaElementDelta delta) {
        this.bus.post((Object)new JavaModelEvents.JarPackageFragmentRootRemoved((JarPackageFragmentRoot)delta.getElement()));
    }

    private Set<IProject> getAllOpenProjects() {
        IProject[] projects;
        HashSet result = Sets.newHashSet();
        IProject[] iProjectArray = projects = this.workspace.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    private IJavaProject toJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    private final class SimulateOpenJavaProjectsJob
    extends WorkspaceJob {
        private SimulateOpenJavaProjectsJob(String name) {
            super(name);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            Set openProjects = JavaModelEventsService.this.getAllOpenProjects();
            monitor.beginTask("", openProjects.size());
            for (IProject project : openProjects) {
                if (JavaProject.hasJavaNature((IProject)project)) {
                    IJavaProject javaProject = JavaModelEventsService.this.toJavaProject(project);
                    JavaModelEventsService.this.fireProjectOpenedEvent(javaProject);
                }
                monitor.worked(1);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

