/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import java.net.URL;
import java.text.MessageFormat;
import javax.inject.Inject;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.recommenders.internal.rcp.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class RootPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private SharedImages images;

    @Inject
    public RootPreferencePage(SharedImages images) {
        this.images = images;
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_EMPTY);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite content = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(content);
        this.createLink(content, Messages.PREFPAGE_LABEL_HOMEPAGE, SharedImages.Images.OBJ_HOMEPAGE, Messages.PREFPAGE_LINK_HOMEPAGE, "http://www.eclipse.org/recommenders/");
        this.createLink(content, Messages.PREFPAGE_LABEL_MANUAL, SharedImages.Images.OBJ_CONTAINER, Messages.PREFPAGE_LINK_MANUAL, "http://www.eclipse.org/recommenders/manual/");
        this.createLink(content, Messages.PREFPAGE_LABEL_FAVORITE, SharedImages.Images.OBJ_FAVORITE_STAR, Messages.PREFPAGE_LINK_FAVORITE, "http://marketplace.eclipse.org/content/eclipse-code-recommenders");
        this.createLink(content, Messages.PREFPAGE_LABEL_TWITTER, SharedImages.Images.OBJ_BIRD_BLUE, Messages.PREFPAGE_LINK_TWITTER, "http://twitter.com/recommenders");
        return new Composite(parent, 0);
    }

    private void createLink(Composite content, String description, SharedImages.Images icon, String urlLabel, String url) {
        CLabel label = new CLabel(content, 1);
        label.setText(description);
        label.setImage(this.images.getImage(icon));
        Link link = new Link(content, 1);
        link.setText(MessageFormat.format(urlLabel, url));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser("recommenders");
                    browser.openURL(new URL(event.text));
                }
                catch (Exception exception) {}
            }
        });
    }
}

