/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.calls;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.calls.JayesCallModel;
import org.eclipse.recommenders.calls.NullCallModel;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SingleZipCallModelProvider
implements ICallModelProvider,
Openable {
    private static final Logger LOG = LoggerFactory.getLogger(SingleZipCallModelProvider.class);
    private final File models;
    private ZipFile zip;
    private final LoadingCache<ITypeName, ICallModel> cache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(30L).build((CacheLoader)new CallNetCacheLoader());

    public SingleZipCallModelProvider(File models) {
        this.models = models;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Optional<ICallModel> acquireModel(UniqueTypeName key) {
        try {
            ICallModel net = (ICallModel)this.cache.get((Object)((ITypeName)key.getName()));
            net.reset();
            return Optional.of((Object)net);
        }
        catch (ExecutionException e) {
            LOG.error("Failed to acquire model for " + key, (Throwable)e);
            return Optional.absent();
        }
    }

    public Set<ITypeName> acquireableTypes() {
        return Zips.types(this.zip.entries(), (String)".jbif");
    }

    public void releaseModel(ICallModel value) {
    }

    private final class CallNetCacheLoader
    extends CacheLoader<ITypeName, ICallModel> {
        private CallNetCacheLoader() {
        }

        public ICallModel load(ITypeName type) throws Exception {
            return (ICallModel)JayesCallModel.load(SingleZipCallModelProvider.this.zip, type).or((Object)NullCallModel.INSTANCE);
        }
    }
}

