/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.factor;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.recommenders.internal.jayes.util.AddressCalc;
import org.eclipse.recommenders.internal.jayes.util.ArrayUtils;
import org.eclipse.recommenders.jayes.factor.AbstractFactor;
import org.eclipse.recommenders.jayes.factor.arraywrapper.IArrayWrapper;
import org.eclipse.recommenders.jayes.factor.opcache.DivisionCache;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class SparseFactor
extends AbstractFactor
implements Cloneable {
    private static final int SIZE_OF_INT = 4;
    private int blockSize;
    private int[] relativeBlockPointers;
    private DivisionCache divCache;

    @Override
    public void setDimensions(int ... dimensions) {
        this.dimensions = Arrays.copyOf(dimensions, dimensions.length);
        this.selections = new int[dimensions.length];
        this.resetSelections();
        this.setDimensionIDs(Arrays.copyOf(this.getDimensionIDs(), dimensions.length));
    }

    @Override
    public void copyValues(IArrayWrapper other) {
        this.validateCut();
        int offset = this.getRealPosition(this.cut.getStart());
        int length = other.length() - offset;
        this.values.arrayCopy(other, offset, offset, length);
    }

    @Override
    public void multiplyCompatible(AbstractFactor compatible) {
        int[] positions = this.prepareMultiplication(compatible);
        this.multiplyPrepared(compatible.values, positions);
    }

    @Override
    public int[] prepareMultiplication(AbstractFactor compatible) {
        if (this.dimensions.length == 0) {
            return new int[2];
        }
        int[] positions = new int[this.values.length()];
        int[] counter = new int[this.dimensions.length];
        int[] positionTransformation = AddressCalc.computeLinearMap(compatible, this.dimensionIDs);
        counter[counter.length - 1] = -1;
        int i = 0;
        while (i < this.relativeBlockPointers.length) {
            int j = 0;
            while (j < this.blockSize) {
                if (i * this.blockSize + j >= this.computeDenseLength()) break;
                AddressCalc.incrementMultiDimensionalCounter(counter, this.dimensions);
                if (this.getRealPosition(this.getOriginalBlockAddress(i)) != 0) {
                    int pos = MathUtils.scalarProduct(counter, positionTransformation);
                    positions[this.getRealPosition((int)(i * this.blockSize + j))] = compatible.getRealPosition(pos);
                }
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private void createSparseValueArray() {
        int nonSparse = this.countNonzeroBlocks();
        this.values.newArray((nonSparse + 1) * this.blockSize);
    }

    private int countNonzeroBlocks() {
        int nonSparse = 0;
        int i = 0;
        while (i < this.relativeBlockPointers.length) {
            if (this.getRealPosition(this.getOriginalBlockAddress(i)) != 0) {
                ++nonSparse;
            }
            ++i;
        }
        return nonSparse;
    }

    private int getOriginalBlockAddress(int blockIndex) {
        return blockIndex * this.blockSize;
    }

    public void sparsify(AbstractFactor ... compatible) {
        if (this.dimensions.length == 0) {
            this.blockSize = 1;
            this.relativeBlockPointers = new int[]{1};
            this.divCache = new DivisionCache(this.blockSize);
            this.createSparseValueArray();
            return;
        }
        this.optimizeDimensionOrder(compatible);
        this.optimizeBlockSize(compatible);
        this.initializeBlockPointers(compatible);
        this.divCache = new DivisionCache(this.blockSize);
        this.createSparseValueArray();
    }

    private void initializeBlockPointers(AbstractFactor ... compatible) {
        int length = this.computeDenseLength();
        this.relativeBlockPointers = new int[(int)Math.ceil((double)length / (double)this.blockSize)];
        int[][] posTransformations = this.computePositionTransformations(compatible);
        int[] counter = new int[this.dimensions.length];
        counter[counter.length - 1] = -1;
        int numberOfNonzeroBlocks = 0;
        int i = 0;
        while (i < this.relativeBlockPointers.length) {
            boolean isZero = this.checkIfPartitionIsZero(i, counter, compatible, posTransformations, this.blockSize);
            this.relativeBlockPointers[i] = isZero ? -this.getOriginalBlockAddress(i) : ++numberOfNonzeroBlocks * this.blockSize - this.getOriginalBlockAddress(i);
            ++i;
        }
    }

    private void optimizeDimensionOrder(AbstractFactor[] compatible) {
        int[][] zerosByDimension = this.countZerosByDimension(compatible);
        double[] infogain = this.computeInfoGain(zerosByDimension);
        this.setDimensionIDs(this.sortByKey(infogain, this.getDimensionIDs()));
        this.setDimensions(this.sortByKey(infogain, this.getDimensions()));
    }

    private int[] indexArray(int length) {
        int[] indices = new int[length];
        int i = 0;
        while (i < length) {
            indices[i] = i;
            ++i;
        }
        return indices;
    }

    private int[] sortByKey(final double[] key, int[] array) {
        int[] permutation = this.sort(this.indexArray(key.length), new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(key[o2], key[o1]);
            }
        });
        return this.permute(array, permutation);
    }

    private int[] sort(int[] array, Comparator<Integer> comparator) {
        Number[] boxed = (Integer[])ArrayUtils.boxArray((Object)array);
        Arrays.sort(boxed, comparator);
        return (int[])ArrayUtils.unboxArray((Number[])boxed);
    }

    private int[] permute(int[] array, int[] permutation) {
        int[] array2 = new int[array.length];
        int i = 0;
        while (i < array.length) {
            array2[i] = array[permutation[i]];
            ++i;
        }
        return array2;
    }

    private double[] computeInfoGain(int[][] zerosByDimension) {
        int totalZeros = 0;
        int i = 0;
        while (i < zerosByDimension[0].length) {
            totalZeros += zerosByDimension[0][i];
            ++i;
        }
        double entropy = this.entropy(totalZeros, this.computeDenseLength() - totalZeros);
        double[] conditionalEntropy = this.conditionalEntropy(zerosByDimension);
        int i2 = 0;
        while (i2 < conditionalEntropy.length) {
            conditionalEntropy[i2] = entropy - conditionalEntropy[i2];
            ++i2;
        }
        return conditionalEntropy;
    }

    private double entropy(int classOne, int classTwo) {
        double p = (double)classOne / (double)(classOne + classTwo);
        if (p == 0.0 || p == 1.0) {
            return 0.0;
        }
        return -(p * Math.log(p) + (1.0 - p) * Math.log(1.0 - p));
    }

    private double[] conditionalEntropy(int[][] zerosByDimension) {
        double[] entropyValues = new double[this.dimensions.length];
        int length = this.computeDenseLength();
        int i = 0;
        while (i < this.dimensions.length) {
            int l = length / this.dimensions[i];
            int j = 0;
            while (j < this.dimensions[i]) {
                int zeroes = zerosByDimension[i][j];
                int n = i;
                entropyValues[n] = entropyValues[n] + this.entropy(zeroes, l - zeroes);
                ++j;
            }
            int n = i;
            entropyValues[n] = entropyValues[n] / (double)this.dimensions[i];
            ++i;
        }
        return entropyValues;
    }

    private int[][] countZerosByDimension(AbstractFactor[] compatible) {
        int[][] zeros = new int[this.dimensions.length][];
        int i = 0;
        while (i < zeros.length) {
            zeros[i] = new int[this.dimensions[i]];
            ++i;
        }
        int[][] foreignIdToIndex = this.computePositionTransformations(compatible);
        int[] counter = new int[this.dimensions.length];
        counter[counter.length - 1] = -1;
        int length = this.computeDenseLength();
        int i2 = 0;
        while (i2 < length) {
            boolean isZero = this.checkIfPartitionIsZero(i2, counter, compatible, foreignIdToIndex, 1);
            if (isZero) {
                int j = 0;
                while (j < this.dimensions.length) {
                    int[] nArray = zeros[j];
                    int n = counter[j];
                    nArray[n] = nArray[n] + 1;
                    ++j;
                }
            }
            ++i2;
        }
        return zeros;
    }

    private int[][] computePositionTransformations(AbstractFactor[] compatible) {
        int[][] localToForeignTransformations = new int[compatible.length][];
        int i = 0;
        while (i < compatible.length) {
            localToForeignTransformations[i] = AddressCalc.computeLinearMap(compatible[i], this.dimensionIDs);
            ++i;
        }
        return localToForeignTransformations;
    }

    private boolean checkIfPartitionIsZero(int partition, int[] counter, AbstractFactor[] compatible, int[][] localToForeignTransformations, int blockSize) {
        boolean isPartitionZero = true;
        int j = 0;
        while (j < blockSize) {
            if (partition * blockSize + j >= this.computeDenseLength()) break;
            AddressCalc.incrementMultiDimensionalCounter(counter, this.dimensions);
            if (isPartitionZero) {
                isPartitionZero &= this.checkIfPositionIsZero(counter, compatible, localToForeignTransformations);
            }
            ++j;
        }
        return isPartitionZero;
    }

    private boolean checkIfPositionIsZero(int[] position, AbstractFactor[] compatible, int[][] localToForeignTransformations) {
        int i = 0;
        while (i < compatible.length) {
            AbstractFactor f = compatible[i];
            int pos = MathUtils.scalarProduct(position, localToForeignTransformations[i]);
            if (f.getValue(pos) == 0.0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void optimizeBlockSize(AbstractFactor[] compatible) {
        int blocksize = this.computeLocallyOptimalPowerOf2BlockSize(compatible);
        this.blockSize = blocksize = this.refineBlockSizeByBinarySearch(blocksize, compatible);
    }

    private int computeLocallyOptimalPowerOf2BlockSize(AbstractFactor[] compatible) {
        int overhead;
        int arraySize;
        int blocksize = 1;
        int newArraySize = this.predictLengthOfValueArray(blocksize, compatible) * this.values.sizeOfElement();
        int newOverhead = this.computeDenseLength() / blocksize * 4;
        do {
            arraySize = newArraySize;
            overhead = newOverhead;
        } while ((newArraySize = this.predictLengthOfValueArray(blocksize *= 2, compatible) * this.values.sizeOfElement()) + (newOverhead = this.computeDenseLength() / blocksize * 4) <= arraySize + overhead);
        return blocksize /= 2;
    }

    private int refineBlockSizeByBinarySearch(int blocksize, AbstractFactor[] compatible) {
        int upperBound = blocksize * 2;
        int lowerBound = blocksize;
        while (upperBound - lowerBound > 1) {
            int middleOverhead;
            int lowerArraySize = this.predictLengthOfValueArray(lowerBound, compatible) * this.values.sizeOfElement();
            int lowerOverhead = this.computeDenseLength() / lowerBound * 4;
            int middle = (lowerBound + upperBound) / 2;
            int middleArraySize = this.predictLengthOfValueArray(middle, compatible) * this.values.sizeOfElement();
            if (middleArraySize + (middleOverhead = this.computeDenseLength() / middle * 4) < lowerArraySize + lowerOverhead) {
                lowerBound = middle;
                continue;
            }
            upperBound = middle;
        }
        return lowerBound;
    }

    private int predictLengthOfValueArray(int blockSize, AbstractFactor[] compatible) {
        int[][] foreignIdToIndex = this.computePositionTransformations(compatible);
        int[] counter = new int[this.dimensions.length];
        counter[counter.length - 1] = -1;
        int length = this.computeDenseLength();
        int futureLength = length + blockSize;
        int i = 0;
        while (i < length / blockSize) {
            boolean isZero = this.checkIfPartitionIsZero(i, counter, compatible, foreignIdToIndex, blockSize);
            if (isZero) {
                futureLength -= blockSize;
            }
            ++i;
        }
        return futureLength;
    }

    @Override
    protected int getRealPosition(int virtualPosition) {
        return this.relativeBlockPointers[this.divCache.apply(virtualPosition)] + virtualPosition;
    }

    private int computeDenseLength() {
        return MathUtils.product(this.dimensions);
    }

    @Override
    public void fill(double d) {
        this.values.fill(d);
        int i = 0;
        while (i < this.blockSize) {
            this.values.set(i, this.isLogScale() ? Double.NEGATIVE_INFINITY : 0.0);
            ++i;
        }
    }

    @Override
    public int getOverhead() {
        return this.relativeBlockPointers.length * 4;
    }

    @Override
    public SparseFactor clone() {
        return (SparseFactor)super.clone();
    }

    public static boolean isSuitable(int futureLength, AbstractFactor ... multiplicationCandidates) {
        if (multiplicationCandidates == null) {
            return false;
        }
        AbstractFactor[] abstractFactorArray = multiplicationCandidates;
        int n = multiplicationCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFactor f = abstractFactorArray[n2];
            if (SparseFactor.isSparseEnough(f, futureLength)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSparseEnough(AbstractFactor f, int futureLength) {
        return SparseFactor.countZeros(f.getValues()) > (double)(2 * MathUtils.product(f.getDimensions())) / Math.sqrt(futureLength);
    }

    private static double countZeros(IArrayWrapper values) {
        int result = 0;
        for (Number d : values) {
            if (d.doubleValue() != 0.0) continue;
            ++result;
        }
        return result;
    }

    public static SparseFactor fromFactor(AbstractFactor f) {
        SparseFactor result = new SparseFactor();
        result.setDimensionIDs((int[])f.getDimensionIDs().clone());
        result.setDimensions((int[])f.getDimensions().clone());
        result.sparsify(f);
        result.setLogScale(f.isLogScale());
        result.fill(!result.isLogScale() ? 1 : 0);
        if (result.isLogScale()) {
            result.multiplyCompatibleToLog(f);
        } else {
            result.multiplyCompatible(f);
        }
        return result;
    }
}

