/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;

class TableComparator
extends ViewerComparator {
    private final ImmutableMap<TableColumn, Comparator<Object>> comparators;
    private final TableViewer tableViewer;
    private final IAction refreshUiAction;
    private int direction = 128;
    private TableColumn tableColumn = null;

    public TableComparator(TableViewer tableViewer, IAction refreshUiAction, ImmutableMap<TableColumn, Comparator<Object>> comparators) {
        this.tableViewer = tableViewer;
        this.refreshUiAction = refreshUiAction;
        this.comparators = comparators;
    }

    public void initial(TableColumn tableColumn, int direction) {
        this.tableColumn = tableColumn;
        this.direction = direction;
    }

    public void sort(TableColumn tableColumn) {
        this.updateDirection(tableColumn);
        this.tableColumn = tableColumn;
        this.tableViewer.getTable().setSortDirection(this.direction);
        this.tableViewer.getTable().setSortColumn(tableColumn);
        this.refreshUiAction.run();
    }

    private void updateDirection(TableColumn tableColumn) {
        if (this.tableColumn == null || !this.tableColumn.equals(tableColumn)) {
            this.direction = 128;
        } else {
            this.toggleDirection();
        }
    }

    private void toggleDirection() throws AssertionError {
        switch (this.direction) {
            case 0: {
                this.direction = 128;
                break;
            }
            case 128: {
                this.direction = 1024;
                break;
            }
            case 1024: {
                this.direction = 0;
                break;
            }
            default: {
                throw new AssertionError((Object)("Sort direction illegal: " + this.direction));
            }
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (this.direction == 0) {
            return 0;
        }
        Comparator comparator = (Comparator)this.comparators.get((Object)this.tableColumn);
        if (comparator == null) {
            return 0;
        }
        return this.direction == 1024 ? comparator.compare(o2, o1) : comparator.compare(o1, o2);
    }
}

