/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.internal.ui.text.java.RelevanceSorter;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetAppliedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SnipmatchCompletionEngine {
    private static final int SEARCH_BOX_WIDTH = 273;
    private final SnipmatchContentAssistProcessor processor;
    private final EventBus bus;
    private final ColorRegistry colorRegistry;
    private final FontRegistry fontRegistry;
    private final ContentAssistant assistant;
    private Shell searchShell;
    private JavaContentAssistInvocationContext context;
    private TemplateProposal selectedProposal;
    private StyledText searchText;
    private AssistantControlState state;

    @Inject
    public SnipmatchCompletionEngine(SnipmatchContentAssistProcessor processor, EventBus bus, ColorRegistry colorRegistry, FontRegistry fontRegistry) {
        this.processor = processor;
        this.bus = bus;
        this.colorRegistry = colorRegistry;
        this.fontRegistry = fontRegistry;
        this.assistant = this.newContentAssistant();
    }

    private ContentAssistant newContentAssistant() {
        ContentAssistant assistant = new ContentAssistant(){

            public void hide() {
                if (!this.isFocused((Control)SnipmatchCompletionEngine.this.searchText) || SnipmatchCompletionEngine.this.state == AssistantControlState.ENABLE_HIDE) {
                    super.hide();
                    SnipmatchCompletionEngine.this.selectedProposal = null;
                }
            }

            private boolean isFocused(Control control) {
                Control focusControl = Display.getCurrent().getFocusControl();
                return control.equals(focusControl);
            }
        };
        assistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                SnipmatchCompletionEngine.this.selectedProposal = null;
                if (SnipmatchCompletionEngine.this.searchShell != null) {
                    SnipmatchCompletionEngine.this.searchShell.dispose();
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                if (proposal instanceof TemplateProposal) {
                    SnipmatchCompletionEngine.this.selectedProposal = (TemplateProposal)proposal;
                } else {
                    SnipmatchCompletionEngine.this.selectedProposal = null;
                }
            }

            public void assistSessionStarted(ContentAssistEvent event) {
            }
        });
        assistant.setShowEmptyList(true);
        assistant.enablePrefixCompletion(true);
        assistant.enableColoredLabels(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator((IInformationControlCreator)new TemplateInformationControlCreator(0x2000000));
        assistant.setEmptyMessage(Messages.COMPLETION_ENGINE_NO_SNIPPETS_FOUND);
        assistant.setRepeatedInvocationMode(true);
        assistant.setStatusLineVisible(true);
        assistant.setSorter((ICompletionProposalSorter)new RelevanceSorter());
        return assistant;
    }

    public void show(JavaContentAssistInvocationContext context) {
        this.context = context;
        this.processor.setContext(context);
        this.assistant.install(context.getViewer());
        this.state = AssistantControlState.KEEP_OPEN;
        this.createSearchPopup();
    }

    private void createSearchPopup() {
        Shell parentShell = this.context.getViewer().getTextWidget().getShell();
        this.searchShell = new Shell(parentShell, 16384);
        this.searchShell.setLayout((Layout)new FillLayout());
        this.searchShell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    SnipmatchCompletionEngine.this.state = AssistantControlState.ENABLE_HIDE;
                    SnipmatchCompletionEngine.this.assistant.uninstall();
                }
            }
        });
        this.searchText = new StyledText((Composite)this.searchShell, 4);
        this.searchText.setFont(this.fontRegistry.get("org.eclipse.recommenders.snipmatch.rcp.searchTextFont"));
        this.searchText.setBackground(this.colorRegistry.get("org.eclipse.recommenders.snipmatch.rcp.searchboxbackground"));
        this.searchText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!SnipmatchCompletionEngine.this.assistant.hasProposalPopupFocus()) {
                    SnipmatchCompletionEngine.this.state = AssistantControlState.ENABLE_HIDE;
                    SnipmatchCompletionEngine.this.searchShell.dispose();
                    SnipmatchCompletionEngine.this.assistant.uninstall();
                }
            }
        });
        this.searchText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                TemplateProposal appliedProposal = SnipmatchCompletionEngine.this.selectedProposal;
                switch (e.character) {
                    case '\r': {
                        e.doit = false;
                        if (appliedProposal != null) {
                            SnipmatchCompletionEngine.this.state = AssistantControlState.ENABLE_HIDE;
                            SnipmatchCompletionEngine.this.assistant.uninstall();
                            if (appliedProposal.isValidFor(SnipmatchCompletionEngine.this.context.getDocument(), SnipmatchCompletionEngine.this.context.getInvocationOffset())) {
                                if (appliedProposal instanceof SnippetProposal) {
                                    SnipmatchCompletionEngine.this.snippetApplied((SnippetProposal)appliedProposal);
                                }
                                appliedProposal.apply(SnipmatchCompletionEngine.this.context.getViewer(), '\u0000', 0, SnipmatchCompletionEngine.this.context.getInvocationOffset());
                                Point selection = appliedProposal.getSelection(SnipmatchCompletionEngine.this.context.getDocument());
                                if (selection != null) {
                                    SnipmatchCompletionEngine.this.context.getViewer().setSelectedRange(selection.x, selection.y);
                                    SnipmatchCompletionEngine.this.context.getViewer().revealRange(selection.x, selection.y);
                                }
                            }
                        } else {
                            SnipmatchCompletionEngine.this.state = AssistantControlState.ENABLE_HIDE;
                            SnipmatchCompletionEngine.this.assistant.uninstall();
                        }
                        return;
                    }
                    case '\t': {
                        e.doit = false;
                        return;
                    }
                }
                if (appliedProposal == null) {
                    return;
                }
                switch (e.keyCode) {
                    case 0x1000001: {
                        this.execute("org.eclipse.ui.edit.text.contentAssist.selectPreviousProposal");
                        return;
                    }
                    case 0x1000002: {
                        this.execute("org.eclipse.ui.edit.text.contentAssist.selectNextProposal");
                        return;
                    }
                }
            }

            private void execute(String commandId) {
                try {
                    SnipmatchCompletionEngine.this.assistant.getHandler(commandId).execute(null);
                }
                catch (ExecutionException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String query = SnipmatchCompletionEngine.this.searchText.getText().trim();
                SnipmatchCompletionEngine.this.processor.setTerms(query);
                SnipmatchCompletionEngine.this.assistant.showPossibleCompletions();
                SnipmatchCompletionEngine.this.assistant.showContextInformation();
            }
        });
        this.placeShell();
        this.searchShell.open();
        this.searchShell.setFocus();
    }

    private void placeShell() {
        this.searchShell.pack();
        int searchBoxHeight = this.searchShell.getSize().y;
        StyledText editorText = this.context.getViewer().getTextWidget();
        Caret caret = editorText.getCaret();
        int lineHeight = caret.getSize().y;
        Point location = caret.getLocation();
        Point anchor = editorText.toDisplay(location.x, location.y + lineHeight - searchBoxHeight);
        this.searchShell.setLocation(anchor.x, anchor.y);
        this.searchShell.setSize(273, searchBoxHeight);
    }

    private void snippetApplied(SnippetProposal proposal) {
        ISnippet snippet = proposal.getSnippet();
        String repoUri = null;
        this.bus.post((Object)new SnippetAppliedEvent(snippet.getUuid(), repoUri));
    }

    private static enum AssistantControlState {
        KEEP_OPEN,
        ENABLE_HIDE;

    }
}

