/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch.rcp.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public class SnippetCodeBuilder {
    private final CompilationUnit ast;
    private final IDocument doc;
    private final ITextSelection textSelection;
    private final Set<String> imports = Sets.newTreeSet();
    private final Set<String> importStatics = Sets.newTreeSet();
    private final HashMap<IVariableBinding, String> vars = Maps.newHashMap();
    private final HashMap<String, Integer> lastVarIndex = Maps.newHashMap();
    private final StringBuilder sb = new StringBuilder();

    public SnippetCodeBuilder(CompilationUnit ast, IDocument doc, ITextSelection textSelection) {
        Preconditions.checkNotNull((Object)ast);
        Preconditions.checkNotNull((Object)doc);
        Preconditions.checkNotNull((Object)textSelection);
        this.ast = ast;
        this.doc = doc;
        this.textSelection = textSelection;
    }

    /*
     * Unable to fully structure code
     */
    public String build() {
        start = this.textSelection.getOffset();
        length = this.textSelection.getLength();
        text = this.textSelection.getText();
        if (text == null) {
            return "";
        }
        chars = text.toCharArray();
        enclosingNode = NodeFinder.perform((ASTNode)this.ast, (int)start, (int)length);
        selection = Selection.createFromStartLength((int)start, (int)length);
        i = 0;
        while (i < chars.length) {
            block21: {
                block20: {
                    c = chars[i];
                    if (Character.isJavaIdentifierPart(c)) break block20;
                    this.sb.append(c);
                    break block21;
                }
                nodeFinder = new NodeFinder(enclosingNode, start + i, 0);
                node = nodeFinder.getCoveringNode();
                if (!selection.covers(node)) ** GOTO lbl-1000
                block0 : switch (node.getNodeType()) {
                    case 42: {
                        name = (SimpleName)node;
                        b = name.resolveBinding();
                        if (b != null) {
                            switch (b.getKind()) {
                                case 2: {
                                    tb = (ITypeBinding)b;
                                    this.appendTypeBinding(name, tb);
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                                case 3: {
                                    vb = (IVariableBinding)b;
                                    uniqueVariableName = this.generateUniqueVariableName(vb, name.toString());
                                    if (this.isDeclaration(name)) {
                                        this.appendNewName(uniqueVariableName, vb);
                                    } else if (this.isDeclaredInSelection(vb, selection)) {
                                        this.appendTemplateVariableReference(uniqueVariableName);
                                    } else if (this.isQualified(name)) {
                                        this.sb.append(name.getIdentifier());
                                    } else if (vb.isField()) {
                                        if (Modifier.isStatic((int)b.getModifiers())) {
                                            this.sb.append(name.getIdentifier());
                                            this.addStaticImport(vb);
                                        } else {
                                            this.appendVarReference(uniqueVariableName, "field", vb);
                                        }
                                    } else {
                                        this.appendVarReference(uniqueVariableName, "var", vb);
                                    }
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                            }
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.sb.append(c);
                    }
                }
            }
            ++i;
        }
        this.sb.append('\n');
        this.appendImportVariable("import", this.imports);
        this.appendImportVariable("importStatic", this.importStatics);
        this.appendCursor();
        this.replaceLeadingWhitespaces();
        return this.sb.toString();
    }

    private boolean isDeclaration(SimpleName name) {
        StructuralPropertyDescriptor locationInParent = name.getLocationInParent();
        if (locationInParent == VariableDeclarationFragment.NAME_PROPERTY) {
            return true;
        }
        return locationInParent == SingleVariableDeclaration.NAME_PROPERTY;
    }

    private boolean isDeclaredInSelection(IVariableBinding binding, Selection selection) {
        ASTNode declaringNode = this.ast.findDeclaringNode((IBinding)binding);
        if (declaringNode == null) {
            return false;
        }
        return selection.covers(declaringNode);
    }

    private boolean isQualified(SimpleName node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        return locationInParent == QualifiedName.NAME_PROPERTY;
    }

    private String generateUniqueVariableName(IVariableBinding binding, String name) {
        if (binding != null && this.vars.containsKey(binding)) {
            return this.vars.get(binding);
        }
        String newName = name;
        Integer i = this.lastVarIndex.containsKey(newName) ? this.lastVarIndex.get(newName) : Integer.valueOf(1);
        while (this.vars.containsValue(newName)) {
            i = i + 1;
            newName = name.concat(i.toString());
        }
        this.lastVarIndex.put(name, i);
        this.vars.put(binding, newName);
        return newName;
    }

    private void appendTypeBinding(SimpleName name, ITypeBinding tb) {
        this.sb.append(name);
        this.addImport(tb);
    }

    private void appendNewName(String name, IVariableBinding binding) {
        ITypeBinding type = binding.getType();
        this.sb.append('$').append('{').append(name).append(':').append("newName").append('(');
        if (type.isArray()) {
            this.sb.append('\'').append(type.getErasure().getQualifiedName()).append('\'');
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(')').append('}');
        this.addImport(type);
    }

    private StringBuilder appendTemplateVariableReference(String name) {
        return this.sb.append('$').append('{').append(name).append('}');
    }

    private void appendVarReference(String name, String kind, IVariableBinding binding) {
        ITypeBinding type = binding.getType();
        this.sb.append('$').append('{').append(name).append(':').append(kind).append('(');
        if (type.isArray()) {
            this.sb.append('\'').append(type.getErasure().getQualifiedName()).append('\'');
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(')').append('}');
        this.addImport(type);
    }

    private void appendImportVariable(String name, Collection<String> imports) {
        if (!imports.isEmpty()) {
            String uniqueName = this.generateUniqueVariableName(null, name);
            String joinedImports = Joiner.on((String)", ").join(imports);
            this.sb.append('$').append('{').append(uniqueName).append(':').append(name).append('(').append(joinedImports).append(')').append('}');
        }
    }

    private void appendCursor() {
        this.sb.append("${cursor}");
    }

    private void addImport(ITypeBinding binding) {
        if (binding.isArray()) {
            this.addImport(binding.getComponentType());
            return;
        }
        IPackageBinding packageBinding = binding.getPackage();
        if (packageBinding == null) {
            return;
        }
        if (packageBinding.getName().equals("java.lang")) {
            return;
        }
        String name = binding.getErasure().getQualifiedName();
        this.imports.add(name);
    }

    private void addStaticImport(IVariableBinding binding) {
        ITypeBinding declaringClass = binding.getDeclaringClass();
        if (declaringClass == null) {
            return;
        }
        String name = declaringClass.getErasure().getQualifiedName();
        this.importStatics.add(String.valueOf(name) + "." + binding.getName());
    }

    private void replaceLeadingWhitespaces() {
        try {
            int startLineIndex = this.textSelection.getStartLine();
            int startLineBeginOffset = this.doc.getLineOffset(startLineIndex);
            int startLineEndOffset = this.doc.getLineOffset(startLineIndex + 1) - 1;
            int lineLength = startLineEndOffset - startLineBeginOffset;
            String line = this.doc.get(startLineBeginOffset, lineLength);
            int index = 0;
            while (index < line.length()) {
                if (!Character.isWhitespace(line.charAt(index))) break;
                ++index;
            }
            String wsPrefix = line.substring(0, index);
            String[] code = this.sb.toString().split("\\r?\\n");
            this.sb.setLength(0);
            String[] stringArray = code;
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String clean = StringUtils.removeStart((String)l, (String)wsPrefix);
                this.sb.append(clean).append(SystemUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SNIPPET_REPLACE_LEADING_WHITESPACE_FAILED, (Throwable)e);
        }
    }
}

