/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SendAction implements Enumerator
{
    ASK(0, "ASK", "ASK"),
    IGNORE(0, "IGNORE", "IGNORE"),
    SILENT(0, "SILENT", "SILENT"),
    PAUSE_DAY(0, "PAUSE_DAY", "PAUSE_DAY"),
    PAUSE_RESTART(0, "PAUSE_RESTART", "PAUSE_RESTART");

    public static final int ASK_VALUE = 0;
    public static final int IGNORE_VALUE = 0;
    public static final int SILENT_VALUE = 0;
    public static final int PAUSE_DAY_VALUE = 0;
    public static final int PAUSE_RESTART_VALUE = 0;
    private static final SendAction[] VALUES_ARRAY;
    public static final List<SendAction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SendAction[]{ASK, IGNORE, SILENT, PAUSE_DAY, PAUSE_RESTART};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SendAction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SendAction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SendAction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SendAction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SendAction get(int value) {
        switch (value) {
            case 0: {
                return ASK;
            }
        }
        return null;
    }

    private SendAction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

