/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.stacktraces.rcp.Browsers;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

class DetailsWizardPage
extends WizardPage {
    private TableViewer tableViewer;
    private StyledText messageText;
    private IObservableList errors;
    private ErrorReport activeSelection;
    private static final Image ERROR_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private StyledText commentText;
    private Settings settings;

    protected DetailsWizardPage(IObservableList errors, Settings settings) {
        super(DetailsWizardPage.class.getName());
        this.errors = errors;
        this.settings = settings;
        this.setTitle(Messages.PREVIEWPAGE_TITLE);
        this.setDescription(Messages.PREVIEWPAGE_DESC);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).applyTo(container);
        Composite tableComposite = this.createTableComposite(container);
        GridDataFactory.fillDefaults().hint(150, -1).minSize(150, -1).span(1, 3).grab(false, true).applyTo((Control)tableComposite);
        Composite messageComposite = this.createMessageComposite(container);
        GridDataFactory.fillDefaults().span(2, 2).grab(true, true).applyTo((Control)messageComposite);
        Composite commentComposite = this.createCommentComposite(container);
        GridDataFactory.fillDefaults().span(2, 1).hint(400, -1).grab(true, false).applyTo((Control)commentComposite);
        this.setControl((Control)container);
    }

    private Composite createTableComposite(Composite container) {
        Composite tableComposite = new Composite(container, 0);
        this.tableViewer = new TableViewer(tableComposite, 68356);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ErrorReport event = (ErrorReport)element;
                return event.getStatus().getMessage();
            }

            public Image getImage(Object element) {
                return ERROR_ICON;
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.tableViewer.setInput((Object)this.errors);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    IStructuredSelection selection = (IStructuredSelection)DetailsWizardPage.this.tableViewer.getSelection();
                    DetailsWizardPage.this.activeSelection = (ErrorReport)selection.getFirstElement();
                    ErrorReport copy = ErrorReports.copy(DetailsWizardPage.this.activeSelection);
                    copy.setName(DetailsWizardPage.this.settings.getName());
                    copy.setEmail(DetailsWizardPage.this.settings.getEmail());
                    DetailsWizardPage.this.messageText.setText(ErrorReports.prettyPrint(copy, DetailsWizardPage.this.settings));
                    String comment = DetailsWizardPage.this.activeSelection.getComment();
                    DetailsWizardPage.this.commentText.setText(comment == null ? "" : comment);
                }
            }
        });
        return tableComposite;
    }

    private Composite createMessageComposite(Composite container) {
        Composite messageComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(messageComposite);
        Label messageLabel = new Label(messageComposite, 4);
        messageLabel.setText(Messages.PREVIEWPAGE_LABEL_MESSAGE);
        GridDataFactory.fillDefaults().applyTo((Control)messageLabel);
        this.messageText = new StyledText(messageComposite, 2816);
        this.messageText.setEditable(false);
        this.messageText.setMargins(5, this.messageText.getTopMargin(), this.messageText.getRightMargin(), this.messageText.getBottomMargin());
        this.messageText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        GridDataFactory.fillDefaults().minSize(150, 1).hint(300, 300).grab(true, true).applyTo((Control)this.messageText);
        return messageComposite;
    }

    private Composite createCommentComposite(Composite container) {
        Composite commentComposite = new Composite(container, 4);
        GridLayoutFactory.fillDefaults().applyTo(commentComposite);
        Label commentLabel = new Label(commentComposite, 0);
        commentLabel.setText(Messages.PREVIEWPAGE_LABEL_COMMENT);
        GridDataFactory.fillDefaults().applyTo((Control)commentLabel);
        this.commentText = new StyledText(commentComposite, 2624);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DetailsWizardPage.this.activeSelection != null) {
                    DetailsWizardPage.this.activeSelection.setComment(DetailsWizardPage.this.commentText.getText());
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 75).applyTo((Control)this.commentText);
        return commentComposite;
    }

    public void setVisible(boolean visible) {
        if (visible && !this.errors.isEmpty()) {
            StructuredSelection selection = new StructuredSelection(this.tableViewer.getElementAt(0));
            this.tableViewer.setSelection((ISelection)selection, true);
        }
        super.setVisible(visible);
    }

    public void performHelp() {
        Browsers.openInExternalBrowser("https://docs.google.com/document/d/14vRLXcgSwy0rEbpJArsR_FftOJW1SjWUAmZuzc2O8YI/pub");
    }
}

