/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.stacktraces.rcp.Browsers;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelPackage;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class SettingsWizardPage
extends WizardPage {
    private ComboViewer actionComboViewer;
    private Text txtEmail;
    private Text txtName;
    private Button btnAnonymizeStacktraces;
    private Button btnClearMessages;
    private Settings settings;

    protected SettingsWizardPage(Settings settings) {
        super(SettingsWizardPage.class.getName());
        this.settings = settings;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.SETTINGSPAGE_TITEL);
        this.setDescription(Messages.SETTINGSPAGE_DESC);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        GridLayoutFactory layoutFactory = GridLayoutFactory.fillDefaults().numColumns(2);
        GridDataFactory dataFactory = GridDataFactory.fillDefaults().grab(true, false);
        Group personalGroup = new Group(container, 92);
        personalGroup.setText(Messages.SETTINGSPAGE_GROUPLABEL_PERSONAL);
        layoutFactory.applyTo((Composite)personalGroup);
        dataFactory.applyTo((Control)personalGroup);
        FieldDecoration infoDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        new Label((Composite)personalGroup, 0).setText(Messages.FIELD_LABEL_NAME);
        this.txtName = new Text((Composite)personalGroup, 2048);
        this.txtName.setMessage(Messages.FIELD_MESSAGE_NAME);
        dataFactory.applyTo((Control)this.txtName);
        ControlDecoration dec = new ControlDecoration((Control)this.txtName, 16512);
        dec.setImage(infoDecoration.getImage());
        dec.setDescriptionText(Messages.FIELD_DESC_NAME);
        new Label((Composite)personalGroup, 0).setText(Messages.FIELD_LABEL_EMAIL);
        this.txtEmail = new Text((Composite)personalGroup, 2048);
        this.txtEmail.setMessage(Messages.FIELD_MESSAGE_EMAIL);
        dataFactory.applyTo((Control)this.txtEmail);
        dec = new ControlDecoration((Control)this.txtEmail, 16512);
        dec.setImage(infoDecoration.getImage());
        dec.setDescriptionText(Messages.FIELD_DESC_EMAIL);
        new Label((Composite)personalGroup, 0).setText(Messages.FIELD_LABEL_ACTION);
        this.actionComboViewer = new ComboViewer((Composite)personalGroup, 8);
        this.actionComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.actionComboViewer.setInput((Object)SendAction.values());
        this.actionComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                SendAction mode = (SendAction)element;
                switch (mode) {
                    case ASK: {
                        return Messages.FIELD_LABEL_ACTION_REPORT_ASK;
                    }
                    case IGNORE: {
                        return Messages.FIELD_LABEL_ACTION_REPORT_NEVER;
                    }
                    case SILENT: {
                        return Messages.FIELD_LABEL_ACTION_REPORT_ALWAYS;
                    }
                    case PAUSE_DAY: {
                        return Messages.FIELD_LABEL_ACTION_REPORT_PAUSE_DAY;
                    }
                    case PAUSE_RESTART: {
                        return Messages.FIELD_LABEL_ACTION_REPORT_PAUSE_RESTART;
                    }
                }
                return super.getText(element);
            }
        });
        this.actionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.settings.getAction()));
        dataFactory.applyTo(this.actionComboViewer.getControl());
        this.btnAnonymizeStacktraces = new Button(container, 32);
        this.btnAnonymizeStacktraces.setText(Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES);
        this.btnClearMessages = new Button(container, 32);
        this.btnClearMessages.setText(Messages.FIELD_LABEL_ANONYMIZE_MESSAGES);
        Composite feedback = new Composite(container, 0);
        layoutFactory.applyTo(feedback);
        dataFactory.grab(true, true).applyTo((Control)feedback);
        Link feedbackLink = new Link(feedback, 0);
        dataFactory.align(1, 0x1000008).applyTo((Control)feedbackLink);
        feedbackLink.setText(Messages.LINK_LEARN_MORE);
        feedbackLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://docs.google.com/document/d/14vRLXcgSwy0rEbpJArsR_FftOJW1SjWUAmZuzc2O8YI/pub");
            }
        });
        feedbackLink = new Link(feedback, 0);
        dataFactory.align(0x1000008, 0x1000008).applyTo((Control)feedbackLink);
        feedbackLink.setText(Messages.LINK_PROVIDE_FEEDBACK);
        feedbackLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://docs.google.com/a/codetrails.com/forms/d/1wd9AzydLv_TMa7ZBXHO7zQIhZjZCJRNMed-6J4fVNsc/viewform");
            }
        });
        this.setControl((Control)container);
        this.createDataBindingContext();
    }

    private DataBindingContext createDataBindingContext() {
        DataBindingContext context = new DataBindingContext();
        ModelPackage pkg = ModelPackage.eINSTANCE;
        ISWTObservableValue ovTxtName = WidgetProperties.text((int)24).observe((Widget)this.txtName);
        IObservableValue ovSetName = EMFProperties.value((EStructuralFeature)pkg.getSettings_Name()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovTxtName, ovSetName, null, null);
        ISWTObservableValue ovTxtEmail = WidgetProperties.text((int)24).observe((Widget)this.txtEmail);
        IObservableValue ovSetEmail = EMFProperties.value((EStructuralFeature)pkg.getSettings_Email()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovTxtEmail, ovSetEmail, null, null);
        ISWTObservableValue ovBtnAnonSt = WidgetProperties.selection().observe((Widget)this.btnAnonymizeStacktraces);
        IObservableValue ovSetAnonSt = EMFProperties.value((EStructuralFeature)pkg.getSettings_AnonymizeStrackTraceElements()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovBtnAnonSt, ovSetAnonSt, null, null);
        ISWTObservableValue ovBtnAnonMsg = WidgetProperties.selection().observe((Widget)this.btnClearMessages);
        IObservableValue ovSetAnonMsg = EMFProperties.value((EStructuralFeature)pkg.getSettings_AnonymizeMessages()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovBtnAnonMsg, ovSetAnonMsg, null, null);
        IViewerObservableValue ovVwrAction = ViewersObservables.observeSinglePostSelection((StructuredViewer)this.actionComboViewer);
        IObservableValue ovSetAction = EMFProperties.value((EStructuralFeature)pkg.getSettings_Action()).observe((Object)this.settings);
        IObservableValue ovPause = EMFProperties.value((EStructuralFeature)pkg.getSettings_PausePeriodStart()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovVwrAction, ovSetAction, null, null);
        context.bindValue((IObservableValue)ovVwrAction, ovPause, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == SendAction.PAUSE_DAY) {
                    return System.currentTimeMillis();
                }
                return 0;
            }
        }, null);
        return context;
    }

    public void performHelp() {
        Browsers.openInExternalBrowser("https://docs.google.com/document/d/14vRLXcgSwy0rEbpJArsR_FftOJW1SjWUAmZuzc2O8YI/pub");
    }
}

