/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.annotations.VisibleForTesting;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.Browsers;
import org.eclipse.recommenders.internal.stacktraces.rcp.ErrorReportWizard;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.ReportState;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

class ThankYouDialog
extends TitleAreaDialog {
    public static final Image TITLE_IMAGE = ErrorReportWizard.TITLE_IMAGE_DESC.createImage();
    private final ReportState state;

    ThankYouDialog(Shell parentShell, ReportState state) {
        super(parentShell);
        this.state = state;
        this.setHelpAvailable(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.THANKYOUDIALOG_THANK_YOU);
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.THANKYOUDIALOG_THANK_YOU);
        this.setMessage(Messages.THANKYOUDIALOG_RECEIVED_AND_TRACKED);
        this.setTitleImage(TITLE_IMAGE);
        Label linetop = new Label(parent, 258);
        linetop.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite border = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        border.setLayout((Layout)layout);
        border.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label linebottom = new Label(parent, 258);
        linebottom.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite container = new Composite(border, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        String text = this.buildText();
        Link link = new Link(container, 64);
        link.setText(text);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser((String)ThankYouDialog.this.state.getBugUrl().get());
            }
        });
        GridDataFactory.defaultsFor((Control)link).align(4, 1).applyTo((Control)link);
        return container;
    }

    @VisibleForTesting
    protected String buildText() {
        StringBuilder text = new StringBuilder();
        if (this.state.isCreated()) {
            String message = MessageFormat.format(Messages.THANKYOUDIALOG_TRACKED_PLEASE_ADD_TO_CC, this.getBugURL());
            text.append(message);
        } else {
            String status = (String)this.state.getStatus().or((Object)"UNCONFIRMED");
            if (ThankYouDialog.equals("UNCONFIRMED", status) || ThankYouDialog.equals("NEW", status) || ThankYouDialog.equals("ASSIGNED", status)) {
                text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MATCHED_PLEASE_ADD_TO_CC, this.getBugURL()));
            } else if (ThankYouDialog.equals("RESOLVED", status) || ThankYouDialog.equals("CLOSED", status)) {
                String resolution = (String)this.state.getResolved().or((Object)"UNKNOWN");
                if (ThankYouDialog.equals("FIXED", resolution)) {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MARKED_FIXED, this.getBugURL()));
                } else if (ThankYouDialog.equals("DUPLICATE", resolution)) {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MARKED_DUPLICATE, this.getBugURL()));
                } else if (ThankYouDialog.equals("MOVED", resolution)) {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MARKED_MOVED, this.getBugURL()));
                } else if (ThankYouDialog.equals("WORKSFORME", resolution)) {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_NOT_ABLE_TO_REPRODUCE_PLEASE_VISIT, this.getBugURL()));
                } else if (ThankYouDialog.equals("WONTFIX", resolution) || ThankYouDialog.equals("INVALID", resolution) || ThankYouDialog.equals("NOT_ECLIPSE", resolution)) {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MARKED_NORMAL, this.getBugURL()));
                } else {
                    text.append(MessageFormat.format(Messages.THANKYOUDIALOG_MARKED_UNKNOWN, resolution, this.getBugURL()));
                }
            } else {
                text.append(Messages.THANKYOUDIALOG_RECEIVED_UNKNOWN_SERVER_RESPONSE);
            }
        }
        boolean needsinfo = ArrayUtils.contains((Object[])((Object[])this.state.getKeywords().or((Object)ReportState.EMPTY_STRINGS)), (Object)"needinfo");
        if (needsinfo) {
            text.append(Messages.THANKYOUDIALOG_MATCHED_NEED_FURTHER_INFORMATION);
            text.append(MessageFormat.format(Messages.THANKYOUDIALOG_FURTHER_INFORMATION, this.state.getInformation().or((Object)Messages.THANKYOUDIALOG_NO_FURTHER_INFORMATIONS)));
        }
        text.append(Messages.THANKYOUDIALOG_PLEASE_NOTE_ADDITIONAL_PERMISSIONS);
        text.append(Messages.THANKYOUDIALOG_THANK_YOU_FOR_HELP);
        return text.toString();
    }

    private String getBugURL() {
        return (String)this.state.getBugUrl().or((Object)Messages.THANKYOUDIALOG_INVALID_SERVER_RESPONSE);
    }

    private static boolean equals(String expected, String actual) {
        return StringUtils.equals((CharSequence)expected, (CharSequence)actual);
    }
}

