/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp.model;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Bundle;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.StackTraceElement;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Status;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Throwable;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Visitor;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.impl.VisitorImpl;
import org.eclipse.recommenders.utils.AnonymousId;
import org.eclipse.recommenders.utils.gson.EmfFieldExclusionStrategy;
import org.eclipse.recommenders.utils.gson.UuidTypeAdapter;

public class ErrorReports {
    private static final String HIDDEN = "HIDDEN";
    private static ModelFactory factory = ModelFactory.eINSTANCE;
    private static final String SOURCE_BEGIN_MESSAGE = "----------------------------------- SOURCE BEGIN -------------------------------------";
    private static final String SOURCE_FILE_REMOVED = "source file contents removed";

    static boolean isWhitelisted(String className, List<String> whitelist) {
        for (String whiteListedPrefix : whitelist) {
            if (!className.startsWith(whiteListedPrefix)) continue;
            return true;
        }
        return false;
    }

    public static ErrorReport copy(ErrorReport org) {
        return (ErrorReport)EcoreUtil.copy((EObject)org);
    }

    public static String toJson(ErrorReport report, Settings settings, boolean pretty) {
        report = ErrorReports.copy(report);
        report.setName(settings.getName());
        report.setEmail(settings.getEmail());
        if (settings.isAnonymizeStrackTraceElements()) {
            ErrorReports.anonymizeStackTrace(report, settings);
        }
        if (settings.isAnonymizeMessages()) {
            ErrorReports.clearMessages(report);
        }
        Gson gson = ErrorReports.createGson(pretty);
        String json = gson.toJson((Object)report);
        return json;
    }

    private static Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new EmfFieldExclusionStrategy());
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        return gson;
    }

    public static ErrorReport newErrorReport(IStatus event, Settings settings) {
        ErrorReport mReport = factory.createErrorReport();
        mReport.setAnonymousId(AnonymousId.getId());
        mReport.setEventId(UUID.randomUUID());
        mReport.setName(settings.getName());
        mReport.setEmail(settings.getEmail());
        mReport.setJavaRuntimeVersion(SystemUtils.JAVA_RUNTIME_VERSION);
        mReport.setEclipseBuildId(System.getProperty("eclipse.buildId", "-"));
        mReport.setEclipseProduct(System.getProperty("eclipse.product", "-"));
        mReport.setOsgiArch(System.getProperty("osgi.arch", "-"));
        mReport.setOsgiWs(System.getProperty("osgi.ws", "-"));
        mReport.setOsgiOs(System.getProperty("org.osgi.framework.os.name", "-"));
        mReport.setOsgiOsVersion(System.getProperty("org.osgi.framework.os.version", "-"));
        mReport.setStatus(ErrorReports.newStatus(event, settings));
        ErrorReports.guessInvolvedPlugins(mReport);
        return mReport;
    }

    private static void guessInvolvedPlugins(ErrorReport mReport) {
        CollectStackTraceElementPackagesVisitor v = new CollectStackTraceElementPackagesVisitor();
        mReport.accept((Visitor)v);
        HashSet unique = Sets.newHashSet();
        for (String pkg : v.packages) {
            while (pkg.contains(".")) {
                org.osgi.framework.Bundle guess = Platform.getBundle((String)pkg);
                pkg = StringUtils.substringBeforeLast((String)pkg, (String)".");
                if (guess == null || !unique.add(guess.getSymbolicName())) continue;
                Bundle mBundle = factory.createBundle();
                mBundle.setName(guess.getSymbolicName());
                mBundle.setVersion(guess.getVersion().toString());
                mReport.getPresentBundles().add((Object)mBundle);
            }
        }
    }

    public static Status newStatus(IStatus status, Settings settings) {
        CoreException coreException;
        IStatus coreExceptionStatus;
        Status mStatus = factory.createStatus();
        mStatus.setMessage(ErrorReports.removeSourceFileContents(status.getMessage()));
        mStatus.setSeverity(status.getSeverity());
        mStatus.setCode(status.getCode());
        mStatus.setPluginId(status.getPlugin());
        org.osgi.framework.Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle != null) {
            mStatus.setPluginVersion(bundle.getVersion().toString());
        }
        EList mChildren = mStatus.getChildren();
        if (status.getException() instanceof CoreException && (coreExceptionStatus = (coreException = (CoreException)status.getException()).getStatus()) != null) {
            mChildren.add(ErrorReports.newStatus(coreExceptionStatus, settings));
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            mChildren.add(ErrorReports.newStatus(child, settings));
            ++n2;
        }
        if (status.getException() != null) {
            Throwable mException = ErrorReports.newThrowable(status.getException());
            mStatus.setException(mException);
        }
        ThrowableFingerprintComputer fingerprint = new ThrowableFingerprintComputer((List<String>)settings.getWhitelistedPackages(), 1024);
        mStatus.accept((Visitor)fingerprint);
        mStatus.setFingerprint(fingerprint.hash());
        return mStatus;
    }

    private static String removeSourceFileContents(String message) {
        if (message.contains(SOURCE_BEGIN_MESSAGE)) {
            return SOURCE_FILE_REMOVED;
        }
        return message;
    }

    public static Throwable newThrowable(java.lang.Throwable throwable) {
        Throwable mThrowable = factory.createThrowable();
        mThrowable.setMessage(throwable.getMessage());
        mThrowable.setClassName(throwable.getClass().getName());
        EList mStackTrace = mThrowable.getStackTrace();
        java.lang.StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            StackTraceElement mStackTraceElement = factory.createStackTraceElement();
            mStackTraceElement.setFileName(stackTraceElement.getFileName());
            mStackTraceElement.setClassName(stackTraceElement.getClassName());
            mStackTraceElement.setMethodName(stackTraceElement.getMethodName());
            mStackTraceElement.setLineNumber(stackTraceElement.getLineNumber());
            mStackTrace.add(mStackTraceElement);
            ++n2;
        }
        java.lang.Throwable cause = throwable.getCause();
        if (cause != null) {
            if (cause == throwable) {
                System.out.println("err");
            }
            mThrowable.setCause(ErrorReports.newThrowable(cause));
        }
        return mThrowable;
    }

    public static void clearMessages(ErrorReport event) {
        event.accept((Visitor)new ClearMessagesVisitor());
    }

    public static void anonymizeStackTrace(ErrorReport report, Settings settings) {
        report.accept((Visitor)new AnonymizeStacktraceVisitor((List<String>)settings.getWhitelistedPackages()));
    }

    public static String prettyPrint(ErrorReport report, Settings settings) {
        if (settings.isAnonymizeStrackTraceElements()) {
            ErrorReports.anonymizeStackTrace(report, settings);
        }
        if (settings.isAnonymizeMessages()) {
            ErrorReports.clearMessages(report);
        }
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        report.accept((Visitor)prettyPrintVisitor);
        return prettyPrintVisitor.builder.toString();
    }

    public static final class AnonymizeStacktraceVisitor
    extends VisitorImpl {
        private List<String> whitelist;

        public AnonymizeStacktraceVisitor(List<String> whitelist) {
            this.whitelist = whitelist;
        }

        public void visit(Throwable throwable) {
            if (!ErrorReports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                throwable.setClassName(ErrorReports.HIDDEN);
            }
        }

        public void visit(StackTraceElement element) {
            if (!ErrorReports.isWhitelisted(element.getClassName(), this.whitelist)) {
                element.setClassName(ErrorReports.HIDDEN);
                element.setMethodName(ErrorReports.HIDDEN);
                element.setFileName(ErrorReports.HIDDEN);
                element.setLineNumber(-1);
            }
        }
    }

    public static final class ClearMessagesVisitor
    extends VisitorImpl {
        public void visit(Status status) {
            status.setMessage(ErrorReports.HIDDEN);
        }

        public void visit(Throwable throwable) {
            throwable.setMessage(ErrorReports.HIDDEN);
        }
    }

    public static final class CollectStackTraceElementPackagesVisitor
    extends VisitorImpl {
        public TreeSet<String> packages = Sets.newTreeSet();

        public void visit(StackTraceElement element) {
            String pkg = StringUtils.replace((String)StringUtils.substringBeforeLast((String)element.getClassName(), (String)"."), (String)".internal.", (String)".");
            this.packages.add(pkg);
        }
    }

    public static class PrettyPrintVisitor
    extends VisitorImpl {
        private static final int RIGHT_PADDING = 20;
        public StringBuilder builder = new StringBuilder();
        private boolean firstThrowable = true;
        private boolean firstBundle = true;

        private void appendAttributes(EObject object, StringBuilder builder) {
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                String line = String.valueOf(String.format("%-20s", String.valueOf(attribute.getName()) + ":")) + object.eGet((EStructuralFeature)attribute) + "\n";
                builder.append(line);
            }
            builder.append("\n");
        }

        private void appendHeadline(String headline, StringBuilder builder) {
            String line = String.valueOf(headline.replaceAll(".", "-")) + "\n";
            builder.append(line);
            builder.append(String.valueOf(headline) + "\n");
            builder.append(line);
        }

        public void visit(ErrorReport report) {
            this.appendHeadline("REPORT", this.builder);
            this.appendAttributes((EObject)report, this.builder);
            super.visit(report);
        }

        public void visit(Status status) {
            this.appendHeadline("STATUS", this.builder);
            this.appendAttributes((EObject)status, this.builder);
            super.visit(status);
        }

        public void visit(Bundle bundle) {
            if (this.firstBundle) {
                this.appendHeadline("BUNDLES", this.builder);
                this.firstBundle = false;
            }
            this.appendAttributes((EObject)bundle, this.builder);
            super.visit(bundle);
        }

        public void visit(Throwable throwable) {
            if (this.firstThrowable) {
                this.appendHeadline("STACKTRACE", this.builder);
                this.firstThrowable = false;
            } else {
                this.builder.append("Caused by: ");
            }
            this.builder.append(String.valueOf(throwable.getClassName()) + ": " + throwable.getMessage() + "\n");
            super.visit(throwable);
        }

        public void visit(StackTraceElement element) {
            this.builder.append("\t at " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")\n");
            super.visit(element);
        }
    }

    public static final class ThrowableFingerprintComputer
    extends VisitorImpl {
        private StringBuilder content = new StringBuilder();
        private List<String> whitelist;
        private int maxframes;

        public ThrowableFingerprintComputer(List<String> whitelist, int maxframes) {
            this.whitelist = whitelist;
            this.maxframes = maxframes;
        }

        public void visit(StackTraceElement element) {
            if (this.maxframes < 0) {
                return;
            }
            --this.maxframes;
            if (ErrorReports.isWhitelisted(element.getClassName(), this.whitelist)) {
                this.content.append(element.getClassName()).append(element.getMethodName());
            }
        }

        public void visit(Throwable throwable) {
            if (ErrorReports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                this.content.append(throwable.getClassName());
            }
        }

        public String hash() {
            return Hashing.murmur3_32().hashUnencodedChars((CharSequence)this.content.toString()).toString();
        }
    }
}

