/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.subwords.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.CompletionContexts;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.NoProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.internal.subwords.rcp.LCSS;
import org.eclipse.recommenders.internal.subwords.rcp.LogMessages;
import org.eclipse.recommenders.internal.subwords.rcp.SubwordsRcpPreferences;
import org.eclipse.recommenders.rcp.utils.TimeDelimitedProgressMonitor;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.ui.IEditorPart;

public class SubwordsSessionProcessor
extends SessionProcessor {
    private static final int SUBWORDS_RANGE_START = -10000;
    private static Field CORE_CONTEXT = (Field)Reflections.getDeclaredField(JavaContentAssistInvocationContext.class, (String)"fCoreContext").orNull();
    private final SubwordsRcpPreferences prefs;

    @Inject
    public SubwordsSessionProcessor(SubwordsRcpPreferences prefs) {
        this.prefs = prefs;
    }

    public void initializeContext(IRecommendersCompletionContext recContext) {
        try {
            JavaContentAssistInvocationContext jdtContext = recContext.getJavaContext();
            ICompilationUnit cu = jdtContext.getCompilationUnit();
            int offset = jdtContext.getInvocationOffset();
            NoProposalCollectingCompletionRequestor collector = new NoProposalCollectingCompletionRequestor();
            cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(5000));
            InternalCompletionContext compContext = collector.getCoreContext();
            CORE_CONTEXT.set(jdtContext, compContext);
            recContext.set(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, (Object)compContext);
            String prefix = this.getPrefix(jdtContext);
            int length = prefix.length();
            recContext.set(CompletionContextKey.COMPLETION_PREFIX, (Object)prefix);
            HashMap baseProposals = Maps.newHashMap();
            recContext.set(CompletionContextKey.JAVA_PROPOSALS, (Object)baseProposals);
            ASTNode completionNode = compContext.getCompletionNode();
            ASTNode completionNodeParent = compContext.getCompletionNodeParent();
            SortedSet<Integer> triggerlocations = this.computeTriggerLocations(offset, completionNode, completionNodeParent, length);
            ITextViewer viewer = jdtContext.getViewer();
            IEditorPart editor = this.lookupEditor(cu);
            HashSet sortkeys = Sets.newHashSet();
            Iterator iterator = triggerlocations.iterator();
            while (iterator.hasNext()) {
                int trigger = (Integer)iterator.next();
                Map<IJavaCompletionProposal, CompletionProposal> newProposals = this.getNewProposals(viewer, editor, trigger);
                this.testAndInsertNewProposals(recContext, baseProposals, sortkeys, newProposals);
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
    }

    private SortedSet<Integer> computeTriggerLocations(int offset, ASTNode completionNode, ASTNode completionNodeParent, int length) {
        TreeSet triggerlocations = Sets.newTreeSet((Comparator)Ordering.natural().reverse());
        int emptyPrefix = offset - length;
        int triggerOffset = Math.min(this.prefs.minPrefixLengthForTypes, length);
        triggerlocations.add(emptyPrefix + triggerOffset);
        triggerlocations.add(emptyPrefix);
        return triggerlocations;
    }

    private String getPrefix(JavaContentAssistInvocationContext jdtContext) throws BadLocationException {
        CharSequence prefix = jdtContext.computeIdentifierPrefix();
        return prefix == null ? "" : prefix.toString();
    }

    private Map<IJavaCompletionProposal, CompletionProposal> getNewProposals(ITextViewer viewer, IEditorPart editor, int triggerOffset) {
        if (triggerOffset < 0) {
            return Maps.newHashMap();
        }
        JavaContentAssistInvocationContext newjdtContext = new JavaContentAssistInvocationContext(viewer, triggerOffset, editor);
        ICompilationUnit cu = newjdtContext.getCompilationUnit();
        ProposalCollectingCompletionRequestor collector = this.computeProposals(cu, newjdtContext, triggerOffset);
        Map proposals = collector.getProposals();
        return proposals != null ? proposals : Maps.newHashMap();
    }

    private void testAndInsertNewProposals(IRecommendersCompletionContext crContext, Map<IJavaCompletionProposal, CompletionProposal> baseProposals, Set<String> sortkeys, Map<IJavaCompletionProposal, CompletionProposal> newProposals) {
        for (Map.Entry<IJavaCompletionProposal, CompletionProposal> entry : newProposals.entrySet()) {
            IJavaCompletionProposal p = entry.getKey();
            String displayString = p.getDisplayString();
            String completion = CompletionContexts.getPrefixMatchingArea((String)displayString);
            if (sortkeys.contains(displayString) || !LCSS.containsSubsequence(completion, crContext.getPrefix())) continue;
            baseProposals.put(p, entry.getValue());
            sortkeys.add(displayString);
        }
    }

    public boolean startSession(IRecommendersCompletionContext crContext) {
        return true;
    }

    private ProposalCollectingCompletionRequestor computeProposals(ICompilationUnit cu, JavaContentAssistInvocationContext coreContext, int offset) {
        ProposalCollectingCompletionRequestor collector = new ProposalCollectingCompletionRequestor(coreContext);
        try {
            cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(5000));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
        return collector;
    }

    @VisibleForTesting
    protected IEditorPart lookupEditor(ICompilationUnit cu) {
        return EditorUtility.isOpenInEditor((Object)cu);
    }

    public void process(final IProcessableProposal proposal) {
        proposal.getProposalProcessorManager().addProcessor(new ProposalProcessor(){
            int[] bestSequence = new int[0];
            String matchingArea;
            String prefix;
            {
                this.matchingArea = CompletionContexts.getPrefixMatchingArea((String)iProcessableProposal.getDisplayString());
            }

            public boolean isPrefix(String prefix) {
                this.prefix = prefix;
                this.bestSequence = LCSS.bestSubsequence(this.matchingArea, prefix);
                return prefix.isEmpty() || this.bestSequence.length > 0;
            }

            public void modifyDisplayString(StyledString displayString) {
                int[] nArray = this.bestSequence;
                int n = this.bestSequence.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    displayString.setStyle(index, 1, StyledString.COUNTER_STYLER);
                    ++n2;
                }
            }

            public int modifyRelevance() {
                if (ArrayUtils.isEmpty((int[])this.bestSequence)) {
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    return 0;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)this.matchingArea, (CharSequence)this.prefix)) {
                    proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, null);
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    return 0;
                }
                if (CharOperation.camelCaseMatch((char[])this.prefix.toCharArray(), (char[])this.matchingArea.toCharArray())) {
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)false);
                    proposal.setTag((IProposalTag)ProposalTag.IS_CAMEL_CASE_MATCH, (Object)true);
                    return 0;
                }
                int score = LCSS.scoreSubsequence(this.bestSequence);
                proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)false);
                proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, (Object)score);
                return score + -10000;
            }
        });
    }
}

