/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.overrides;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.IOverrideModelProvider;
import org.eclipse.recommenders.overrides.JayesOverrideModel;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.names.ITypeName;

public class SingleZipOverrideModelProvider
implements IOverrideModelProvider,
Openable {
    private final File models;
    private ZipFile zip;

    public SingleZipOverrideModelProvider(File models) {
        this.models = models;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Set<ITypeName> acquireableTypes() {
        return Zips.types((ZipFile)this.zip, (String)".json");
    }

    public void releaseModel(IOverrideModel value) {
    }

    public Optional<IOverrideModel> acquireModel(IUniqueName<ITypeName> key) {
        try {
            return JayesOverrideModel.load(this.zip, (ITypeName)key.getName());
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
    }
}

