/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.internal.snipmatch.rcp.JavaEditorSearchContext;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.RepositoryProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchTemplateContextType;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.models.IDependencyListener;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SnipmatchContentAssistProcessor
implements IContentAssistProcessor {
    private final Repositories repos;
    private final SnippetRepositoryConfigurations configs;
    private final IProjectCoordinateProvider pcProvider;
    private final IDependencyListener dependencyListener;
    private final Image snippetImage;
    private final TemplateContextType snipmatchContextType;
    private JavaContentAssistInvocationContext context;
    private String terms;

    @Inject
    public SnipmatchContentAssistProcessor(SnippetRepositoryConfigurations configs, Repositories repos, IProjectCoordinateProvider pcProvider, IDependencyListener dependencyListener, SharedImages images) {
        this.repos = repos;
        this.configs = configs;
        this.dependencyListener = dependencyListener;
        this.pcProvider = pcProvider;
        this.snippetImage = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_BULLET_BLUE);
        this.snipmatchContextType = SnipmatchTemplateContextType.getInstance();
    }

    public void setContext(JavaContentAssistInvocationContext context) {
        this.context = context;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (StringUtils.isEmpty((CharSequence)this.terms)) {
            return new ICompletionProposal[0];
        }
        JavaEditorSearchContext searchContext = new JavaEditorSearchContext(this.terms, this.context, this.dependencyListener, this.pcProvider);
        LinkedList proposals = Lists.newLinkedList();
        ArrayList sortedConfigs = Lists.newArrayList();
        sortedConfigs.addAll(this.configs.getRepos());
        Collections.sort(sortedConfigs, new Comparator<SnippetRepositoryConfiguration>(){

            @Override
            public int compare(SnippetRepositoryConfiguration o1, SnippetRepositoryConfiguration o2) {
                return Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        Point selection = viewer.getSelectedRange();
        Region region = new Region(selection.x, selection.y);
        Position p = new Position(selection.x, selection.y);
        IDocument document = viewer.getDocument();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        ICompilationUnit cu = this.context.getCompilationUnit();
        JavaContext javaContext = new JavaContext(this.snipmatchContextType, document, p, cu);
        javaContext.setVariable("selection", selectedText);
        javaContext.setForceEvaluation(true);
        int repositoryPriority = 0;
        while (repositoryPriority < sortedConfigs.size()) {
            List recommendations;
            Optional<ISnippetRepository> repo = this.repos.getRepository(((SnippetRepositoryConfiguration)sortedConfigs.get(repositoryPriority)).getId());
            if (repo.isPresent() && !(recommendations = ((ISnippetRepository)repo.get()).search((ISearchContext)searchContext)).isEmpty()) {
                proposals.add(new RepositoryProposal((SnippetRepositoryConfiguration)sortedConfigs.get(repositoryPriority), repositoryPriority, recommendations.size()));
                for (Recommendation recommendation : recommendations) {
                    ISnippet snippet = (ISnippet)recommendation.getProposal();
                    Template template = new Template(snippet.getName(), snippet.getDescription(), "Snipmatch-Java-Context", snippet.getCode(), true);
                    try {
                        proposals.add(SnippetProposal.newSnippetProposal((Recommendation<ISnippet>)recommendation, repositoryPriority, template, (TemplateContext)javaContext, (IRegion)region, this.snippetImage));
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_CREATING_SNIPPET_PROPOSAL_FAILED, (Throwable)e);
                    }
                }
            }
            ++repositoryPriority;
        }
        return (ICompletionProposal[])Iterables.toArray((Iterable)proposals, ICompletionProposal.class);
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }
}

