/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.utils.Logs;
import org.osgi.service.prefs.BackingStoreException;

public class SnipmatchRcpPreferences {
    private static final String SEPARATOR = ";";
    private final EventBus bus;
    private Set<String> disabledRepositories = Sets.newHashSet();

    @Inject
    public SnipmatchRcpPreferences(EventBus bus) {
        this.bus = bus;
    }

    @Inject
    public void setDisabledRepositoryConfigurations(@Preference(value="org.eclipse.recommenders.snipmatch.rcp.disabledrepositoryconfigurations") String newDisabledRepositoryConfiguration) throws Exception {
        if (newDisabledRepositoryConfiguration == null) {
            return;
        }
        Set<String> newDisabledRepositories = SnipmatchRcpPreferences.splitDisabledRepositoryString(newDisabledRepositoryConfiguration);
        if (this.disabledRepositories.equals(newDisabledRepositories)) {
            return;
        }
        this.disabledRepositories = newDisabledRepositories;
        this.bus.post((Object)new Repositories.SnippetRepositoryConfigurationChangedEvent());
    }

    public boolean isRepositoryEnabled(SnippetRepositoryConfiguration config) {
        return !this.disabledRepositories.contains(config.getId());
    }

    public void setRepositoryEnabled(SnippetRepositoryConfiguration config, boolean enabled) {
        HashSet temp = Sets.newHashSet(this.disabledRepositories);
        if (enabled) {
            temp.remove(config.getId());
        } else {
            temp.add(config.getId());
        }
        SnipmatchRcpPreferences.store(SnipmatchRcpPreferences.joinDisabledRepositoriesToString(temp));
    }

    public static Set<String> splitDisabledRepositoryString(String disabledRepositoryConfigurations) {
        Iterable split = Splitter.on((String)SEPARATOR).omitEmptyStrings().split((CharSequence)disabledRepositoryConfigurations);
        return Sets.newHashSet((Iterable)split);
    }

    public static String joinDisabledRepositoriesToString(Collection<String> disabledRepositoryConfigurations) {
        return Joiner.on((String)SEPARATOR).join(disabledRepositoryConfigurations);
    }

    public static void store(String disabledRepositoryConfigurations) {
        IEclipsePreferences s = InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.snipmatch.rcp");
        s.put("org.eclipse.recommenders.snipmatch.rcp.disabledrepositoryconfigurations", disabledRepositoryConfigurations);
        try {
            s.flush();
        }
        catch (BackingStoreException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_STORING_DISABLED_REPOSITORY_CONFIGURATIONS, (Throwable)e);
        }
    }
}

