/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.internal.stacktraces.rcp.ErrorReportWizard;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.PreferenceInitializer;
import org.eclipse.recommenders.internal.stacktraces.rcp.StandInStacktraceProvider;
import org.eclipse.recommenders.internal.stacktraces.rcp.UploadJob;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;

public class LogListener
implements ILogListener,
IStartup {
    private Cache<String, ErrorReport> cache = CacheBuilder.newBuilder().maximumSize(30L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private IObservableList errorReports;
    private volatile boolean isDialogOpen;
    private Settings settings;
    private StandInStacktraceProvider stacktraceProvider = new StandInStacktraceProvider();

    public LogListener() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.errorReports = Properties.selfList(ErrorReport.class).observe((Object)Lists.newArrayList());
            }
        });
    }

    public void earlyStartup() {
        Platform.addLogListener((ILogListener)this);
    }

    public void logging(IStatus status, String nouse) {
        try {
            if (this.skipSendingReports() || !this.isErrorSeverity(status) || this.isRuntimeEclipse()) {
                return;
            }
            this.settings = this.readSettings();
            if (!LogListener.hasPluginIdWhitelistedPrefix(status, (List<String>)this.settings.getWhitelistedPluginIds())) {
                return;
            }
            SendAction sendAction = this.settings.getAction();
            if (!this.isSendingAllowedOnAction(sendAction)) {
                return;
            }
            this.stacktraceProvider.insertStandInStacktraceIfEmpty(status);
            ErrorReport report = ErrorReports.newErrorReport(status, this.settings);
            if (this.settings.isSkipSimilarErrors() && this.sentSimilarErrorBefore(report)) {
                return;
            }
            this.addForSending(report);
            if (sendAction == SendAction.ASK) {
                this.checkAndSendWithDialog(report);
            } else if (sendAction == SendAction.SILENT) {
                this.sendAndClear();
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.REPORTING_ERROR, (Throwable)e);
        }
    }

    private boolean skipSendingReports() {
        return Boolean.getBoolean("org.eclipse.recommenders.stacktraces.rcp.skipReports");
    }

    private boolean isErrorSeverity(IStatus status) {
        return status.matches(4);
    }

    private boolean isRuntimeEclipse() {
        return System.getProperty("eclipse.buildId") == null;
    }

    @VisibleForTesting
    protected Settings readSettings() {
        return PreferenceInitializer.readSettings();
    }

    private static boolean hasPluginIdWhitelistedPrefix(IStatus status, List<String> whitelistedIdPrefixes) {
        String pluginId = status.getPlugin();
        for (String id : whitelistedIdPrefixes) {
            if (!pluginId.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isSendingAllowedOnAction(SendAction sendAction) {
        return sendAction == SendAction.ASK || sendAction == SendAction.SILENT;
    }

    private boolean sentSimilarErrorBefore(ErrorReport report) {
        return this.cache.getIfPresent((Object)this.computeCacheKey(report)) != null;
    }

    private String computeCacheKey(ErrorReport report) {
        return report.getStatus().getFingerprint();
    }

    private void addForSending(final ErrorReport report) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.errorReports.add((Object)report);
            }
        });
        this.cache.put((Object)this.computeCacheKey(report), (Object)report);
    }

    @VisibleForTesting
    protected void checkAndSendWithDialog(ErrorReport report) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LogListener.this.isDialogOpen) {
                    return;
                }
                LogListener.this.isDialogOpen = true;
                ErrorReportWizard stacktraceWizard = new ErrorReportWizard(LogListener.this.settings, LogListener.this.errorReports);
                WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)stacktraceWizard);
                int open = wizardDialog.open();
                LogListener.this.isDialogOpen = false;
                if (open != 0) {
                    LogListener.this.clear();
                    return;
                }
                if (LogListener.this.settings.getAction() == SendAction.IGNORE || LogListener.this.settings.getAction() == SendAction.PAUSE_DAY || LogListener.this.settings.getAction() == SendAction.PAUSE_RESTART) {
                    return;
                }
                LogListener.this.sendAndClear();
            }
        });
    }

    private void sendAndClear() {
        this.sendList();
        this.clear();
    }

    private void sendList() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (Object entry : LogListener.this.errorReports) {
                    ErrorReport report = (ErrorReport)Checks.cast(entry);
                    LogListener.this.sendStatus(report);
                }
            }
        });
    }

    @VisibleForTesting
    protected void sendStatus(ErrorReport report) {
        if (this.settings.getAction() == SendAction.IGNORE || this.settings.getAction() == SendAction.PAUSE_DAY || this.settings.getAction() == SendAction.PAUSE_RESTART) {
            return;
        }
        new UploadJob(report, this.settings, URI.create(this.settings.getServerUrl())).schedule();
    }

    private void clear() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.errorReports.clear();
            }
        });
    }
}

