/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.internal.stacktraces.rcp.Constants;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final long MS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    static boolean flagFirstAccess = true;

    public void initializeDefaultPreferences() {
        IEclipsePreferences s = DefaultScope.INSTANCE.getNode("org.eclipse.recommenders.stacktraces.rcp");
        s.put("server-url", Constants.SERVER_URL);
        s.put("name", "");
        s.put("email", "");
        s.putBoolean("skip-similar-errors", true);
        s.put("whitelisted-plugins", "org.eclipse.;org.apache.log4j.;com.codetrails.;");
        s.put("whitelisted-packages", "org.eclipse.;;;org.apache.;java.;javax.;javafx.;sun.;com.sun.;com.codetrails.;org.osgi.;com.google.;ch.qos.;org.slf4j.;");
        s.put("send-action", SendAction.ASK.name());
        s.putBoolean("anonymize-stacktraces", true);
        s.putBoolean("anonymize-messages", false);
    }

    public static Settings readSettings() {
        ScopedPreferenceStore s = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp");
        Settings settings = ModelFactory.eINSTANCE.createSettings();
        settings.setName(s.getString("name"));
        settings.setEmail(s.getString("email"));
        settings.setSkipSimilarErrors(s.getBoolean("skip-similar-errors"));
        settings.setServerUrl(s.getString("server-url"));
        settings.getWhitelistedPluginIds().addAll(PreferenceInitializer.parseWhitelist(s.getString("whitelisted-plugins")));
        settings.getWhitelistedPackages().addAll(PreferenceInitializer.parseWhitelist(s.getString("whitelisted-packages")));
        settings.setAnonymizeMessages(s.getBoolean("anonymize-messages"));
        settings.setAnonymizeStrackTraceElements(s.getBoolean("anonymize-stacktraces"));
        settings.setAction(PreferenceInitializer.parseSendAction(s.getString("send-action"), s.getLong("pause-period-start")));
        return settings;
    }

    public static void saveSettings(Settings settings) {
        ScopedPreferenceStore s = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp");
        s.setValue("name", settings.getName());
        s.setValue("email", settings.getEmail());
        s.setValue("skip-similar-errors", settings.isSkipSimilarErrors());
        s.setValue("anonymize-stacktraces", settings.isAnonymizeStrackTraceElements());
        s.setValue("anonymize-messages", settings.isAnonymizeMessages());
        s.setValue("send-action", settings.getAction().name());
        s.setValue("pause-period-start", settings.getPausePeriodStart());
        try {
            s.save();
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.SAVE_PREFERENCES_FAILED, (Throwable)e);
        }
    }

    static ArrayList<String> parseWhitelist(String s) {
        Iterable ids = Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)s);
        return Lists.newArrayList((Iterable)ids);
    }

    static SendAction parseSendAction(String mode, long pauseTimestamp) {
        try {
            SendAction value = SendAction.valueOf((String)mode);
            if (PreferenceInitializer.isPausePeriodElapsed(pauseTimestamp, value)) {
                value = SendAction.ASK;
                Logs.log((Logs.ILogMessage)LogMessages.PAUSE_PERIOD_ELAPSED);
            }
            flagFirstAccess = false;
            return value;
        }
        catch (Exception exception) {
            return SendAction.ASK;
        }
    }

    private static boolean isPausePeriodElapsed(long pauseTimestamp, SendAction value) {
        if (value == SendAction.PAUSE_RESTART && flagFirstAccess) {
            return true;
        }
        if (value == SendAction.PAUSE_DAY) {
            long elapsedTime = System.currentTimeMillis() - pauseTimestamp;
            return elapsedTime >= MS_PER_DAY;
        }
        return false;
    }
}

