/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.recommenders.internal.stacktraces.rcp.Constants;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;

public class StandInStacktraceProvider {
    private static final String STAND_IN_MESSAGE = "Stand-In Stacktrace supplied by Eclipse Stacktraces & Error Reporting Tool";
    private static Method SET_EXCEPTION = (Method)Reflections.getDeclaredMethod(Status.class, (String)"setException", (Class[])new Class[]{Throwable.class}).orNull();

    protected void insertStandInStacktraceIfEmpty(IStatus status) {
        if (this.requiresStandInStacktrace(status)) {
            StandInException syntetic = new StandInException(STAND_IN_MESSAGE);
            syntetic.fillInStackTrace();
            StackTraceElement[] stacktrace = syntetic.getStackTrace();
            StackTraceElement[] clearedStacktrace = this.clearBlacklistedTopStackframes(stacktrace, Constants.STAND_IN_STACKTRACE_BLACKLIST);
            syntetic.setStackTrace(clearedStacktrace);
            try {
                SET_EXCEPTION.invoke((Object)status, syntetic);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{SET_EXCEPTION});
            }
        }
    }

    private boolean requiresStandInStacktrace(IStatus status) {
        if (status.getException() != null) {
            return false;
        }
        return status instanceof Status;
    }

    protected StackTraceElement[] clearBlacklistedTopStackframes(StackTraceElement[] stackframes, Set<String> blacklistedClassNames) {
        if (ArrayUtils.isEmpty((Object[])stackframes)) {
            return stackframes;
        }
        int index = this.findCutOffIndex(stackframes, blacklistedClassNames);
        return (StackTraceElement[])ArrayUtils.subarray((Object[])stackframes, (int)index, (int)stackframes.length);
    }

    private int findCutOffIndex(StackTraceElement[] stackframes, Set<String> blacklistedClassNames) {
        int i = 0;
        while (i < stackframes.length) {
            StackTraceElement current = stackframes[i];
            if (!blacklistedClassNames.contains(current.getClassName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static class StandInException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StandInException(String message) {
            super(message);
        }
    }
}

