/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.ReportNotificationPopup;
import org.eclipse.recommenders.internal.stacktraces.rcp.ReportState;
import org.eclipse.recommenders.internal.stacktraces.rcp.ThankYouDialog;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.net.Proxies;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;

public class UploadJob
extends Job {
    private Executor executor;
    private ErrorReport event;
    private URI target;
    private Settings settings;

    UploadJob(ErrorReport event, Settings settings, URI target) {
        super(MessageFormat.format(Messages.UPLOADJOB_NAME, target));
        this.event = event;
        this.settings = settings;
        this.target = target;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.UPLOADJOB_TASKNAME, 1);
        try {
            this.executor = Executor.newInstance();
            String body = ErrorReports.toJson(this.event, this.settings, false);
            Request request = Request.Post((URI)this.target).bodyString(body, ContentType.APPLICATION_JSON);
            Response response = Proxies.proxy((Executor)this.executor, (URI)this.target).execute(request);
            HttpResponse httpResponse = response.returnResponse();
            String details = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            int code = httpResponse.getStatusLine().getStatusCode();
            if (code >= 400) {
                Status status = new Status(2, "org.eclipse.recommenders.stacktraces.rcp", MessageFormat.format(Messages.UPLOADJOB_BAD_RESPONSE, details));
                return status;
            }
            final ReportState state = (ReportState)GsonUtil.deserialize((String)details, ReportState.class);
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(){

                public void run() {
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    new ThankYouDialog(activeShell, state).open();
                }
            });
            if ("FIXED".equals(state.getResolved().orNull())) {
                String message = MessageFormat.format(Messages.UPLOADJOB_ALREADY_FIXED_UPDATE, state.getInformation().or((Object)"The error you reported has been fixed."), state.getBugUrl().or((Object)Messages.THANKYOUDIALOG_INVALID_SERVER_RESPONSE));
                this.openPopup(message);
            } else if (ArrayUtils.contains((Object[])((Object[])state.getKeywords().or((Object)ReportState.EMPTY_STRINGS)), (Object)"needinfo")) {
                String message = MessageFormat.format(Messages.UPLOADJOB_NEED_FURTHER_INFORMATION, state.getBugUrl().or((Object)Messages.THANKYOUDIALOG_INVALID_SERVER_RESPONSE));
                this.openPopup(message);
            }
            Status status = new Status(1, "org.eclipse.recommenders.stacktraces.rcp", MessageFormat.format(Messages.UPLOADJOB_THANK_YOU, details));
            return status;
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipse.recommenders.stacktraces.rcp", Messages.UPLOADJOB_FAILED_WITH_EXCEPTION, (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private void openPopup(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ReportNotificationPopup dialog = new ReportNotificationPopup(message);
                dialog.open();
            }
        });
    }
}

