/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IAnnotation;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IPackageName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmAnnotation;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class Names {
    public static final int STYLE_SHORT = 0;
    public static final int STYLE_LONG = 1;
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String FLOAT = "float";
    public static final String INT = "int";
    public static final String SHORT = "short";
    public static final String BYTE = "byte";
    public static final String CHAR = "char";
    public static final String BOOLEAN = "boolean";
    public static final String VOID = "void";

    public static String[] parseMethodSignature1(String methodSignature) {
        char car;
        Checks.ensureIsNotNull(methodSignature, "s", new Object[0]);
        int openingBracket = methodSignature.indexOf(40);
        ArrayList<String> res = new ArrayList<String>();
        res.add(methodSignature.substring(0, openingBracket));
        char[] desc = methodSignature.substring(openingBracket).toCharArray();
        int off = 1;
        while ((car = desc[off]) != ')') {
            switch (car) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    res.add(Names.internal_vm2srcTypeName(desc, off++));
                    break;
                }
                case 'L': {
                    res.add(Names.internal_vm2srcTypeName(desc, off));
                    off = Names.internal_findEndOfObjectType(desc, off);
                    break;
                }
                case '[': {
                    res.add(Names.internal_vm2srcTypeName(desc, off));
                    while (desc[off] == '[') {
                        ++off;
                    }
                    if (desc[off] == 'L') {
                        off = Names.internal_findEndOfObjectType(desc, off);
                        break;
                    }
                    ++off;
                }
            }
        }
        res.add(Names.internal_vm2srcTypeName(desc, off + 1));
        return res.toArray(new String[res.size()]);
    }

    private static int internal_findEndOfObjectType(char[] desc, int off) {
        Checks.ensureIsNotNull(desc, "desc", new Object[0]);
        int index = off;
        while (index < desc.length) {
            if (desc[index] == ';') {
                return index + 1;
            }
            ++index;
        }
        return desc.length;
    }

    private static String internal_vm2srcTypeName(char[] buf, int off) {
        Checks.ensureIsNotNull(buf, "buf", new Object[0]);
        switch (buf[off]) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'C': {
                return CHAR;
            }
            case 'B': {
                return BYTE;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case '[': {
                StringBuilder sb = new StringBuilder();
                sb.append("[]");
                int len = 1;
                while (buf[off + len] == '[') {
                    sb.append("[]");
                    ++len;
                }
                sb.insert(0, Names.internal_vm2srcTypeName(buf, off + len));
                return sb.toString();
            }
            case 'L': {
                int len = 1;
                while (off + len < buf.length && buf[off + len] != ';') {
                    ++len;
                }
                return new String(buf, off + 1, len - 1).replaceAll("/", ".").replaceAll("\\$", ".");
            }
        }
        throw Throws.throwUnreachable("couldn't handle '%s'", new Object[]{buf});
    }

    public static String[] parseMethodSignature2(String vmMethodSignature) {
        int indexOfDot = vmMethodSignature.indexOf(46);
        String declaringType = vmMethodSignature.substring(0, indexOfDot);
        String methodNameAndDesciptor = vmMethodSignature.substring(indexOfDot + 1);
        return new String[]{declaringType, methodNameAndDesciptor};
    }

    public static String[] parseMethodSignature3(String vmMethodSignature) {
        int lastDot = vmMethodSignature.lastIndexOf(46);
        int firstBracket = vmMethodSignature.lastIndexOf(40);
        String type = vmMethodSignature.substring(0, lastDot);
        String methodName = vmMethodSignature.substring(lastDot + 1, firstBracket);
        String methodDescriptor = vmMethodSignature.substring(firstBracket);
        return new String[]{type, methodName, methodDescriptor};
    }

    public static String src2vmMethod(String srcDeclaringType, String methodName, String[] srcParameterTypes, String srcReturnType) {
        String vmDeclaringTypeName = Names.src2vmType(srcDeclaringType);
        String vmMethodName = Names.src2vmMethod(methodName, srcParameterTypes, srcReturnType);
        return String.valueOf(vmDeclaringTypeName) + "." + vmMethodName;
    }

    public static String src2vmMethod(String methodName, String[] srcParameterTypes, String srcReturnType) {
        Checks.ensureIsNotNull(methodName, "methodName", new Object[0]);
        Checks.ensureIsNotNull(srcParameterTypes, "srcParameterTypes", new Object[0]);
        Checks.ensureIsNotNull(srcReturnType, "srcReturnType", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append('(');
        String[] stringArray = srcParameterTypes;
        int n = srcParameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String srcType = stringArray[n2];
            String vmType = Names.src2vmType(srcType);
            sb.append(vmType);
            if (vmType.startsWith("L")) {
                sb.append(';');
            }
            ++n2;
        }
        String vmReturnType = Names.src2vmType(srcReturnType);
        if (vmReturnType.startsWith("L")) {
            vmReturnType = String.valueOf(vmReturnType) + ";";
        }
        sb.append(')').append(vmReturnType);
        return sb.toString();
    }

    public static String src2vmType(String type) {
        PrimitiveType p;
        Checks.ensureIsNotNull(type, "type", new Object[0]);
        int dimensions = 0;
        if (type.endsWith("]")) {
            dimensions = StringUtils.countMatches((CharSequence)type, (CharSequence)"[]");
            type = String.valueOf(StringUtils.substringBefore((String)type, (String)"[")) + ";";
        }
        if ((p = PrimitiveType.fromSrc(StringUtils.substringBefore((String)type, (String)";"))) != null) {
            return String.valueOf(StringUtils.repeat((String)"[", (int)dimensions)) + p.vm();
        }
        return String.valueOf(StringUtils.repeat((String)"[", (int)dimensions)) + "L" + type.replaceAll("\\.", "/");
    }

    public static List<String> src2vmType(String[] srcTypes) {
        Checks.ensureIsNotNull(srcTypes, "srcTypes", new Object[0]);
        LinkedList<String> res = new LinkedList<String>();
        String[] stringArray = srcTypes;
        int n = srcTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String srcName = stringArray[n2];
            res.add(Names.src2vmType(srcName));
            ++n2;
        }
        return res;
    }

    public static String vm2srcPackage(IPackageName pkg) {
        Checks.ensureIsNotNull(pkg, "pkg", new Object[0]);
        return pkg.getIdentifier().replace('/', '.');
    }

    public static String vm2srcQualifiedMethod(IMethodName method) {
        StringBuilder sb = new StringBuilder();
        ITypeName declaringType = method.getDeclaringType();
        sb.append(Names.vm2srcQualifiedType(declaringType));
        sb.append('.');
        sb.append(method.getName());
        sb.append('(');
        ITypeName[] iTypeNameArray = method.getParameterTypes();
        int n = iTypeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeName param = iTypeNameArray[n2];
            sb.append(Names.vm2srcSimpleTypeName(param)).append(", ");
            ++n2;
        }
        if (method.hasParameters()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    public static String vm2srcQualifiedType(ITypeName type) {
        if (type.isPrimitiveType()) {
            return Names.vm2srcSimpleTypeName(type);
        }
        if (type.isArrayType()) {
            return String.valueOf(Names.vm2srcQualifiedType(type.getArrayBaseType())) + StringUtils.repeat((String)"[]", (int)type.getArrayDimensions());
        }
        String s = type.getIdentifier();
        s = s.replace('/', '.');
        return s.substring(1);
    }

    public static String vm2srcSimpleMethod(IMethodName name) {
        Checks.ensureIsNotNull(name, "name", new Object[0]);
        StringBuilder sb = new StringBuilder();
        if (name.getName().equals("<subtype-init>")) {
            sb.append("ConstructorCallFromSubtype");
        } else {
            sb.append(name.isInit() ? "new " + Names.vm2srcSimpleTypeName(name.getDeclaringType()) : name.getName());
        }
        sb.append('(');
        ITypeName[] iTypeNameArray = name.getParameterTypes();
        int n = iTypeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeName param = iTypeNameArray[n2];
            sb.append(Names.vm2srcSimpleTypeName(param)).append(", ");
            ++n2;
        }
        if (name.getParameterTypes().length > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(')');
        return sb.toString();
    }

    public static String vm2srcSimpleTypeName(String vmTypeName) {
        Checks.ensureIsNotNull(vmTypeName, "vmTypeName", new Object[0]);
        String type = Names.internal_vm2srcTypeName(vmTypeName.toCharArray(), 0);
        int lastDot = type.lastIndexOf(46);
        if (lastDot == -1) {
            return type;
        }
        return type.substring(lastDot + 1);
    }

    public static String vm2srcSimpleTypeName(ITypeName type) {
        if (type.isArrayType()) {
            int arrayDimensions = type.getArrayDimensions();
            ITypeName arrayBaseType = type.getArrayBaseType();
            StringBuilder sb = new StringBuilder();
            String simpleBaseType = Names.vm2srcSimpleTypeName(arrayBaseType);
            sb.append(simpleBaseType);
            int i = arrayDimensions;
            while (i-- > 0) {
                sb.append("[]");
            }
            return sb.toString();
        }
        if (type.isPrimitiveType()) {
            if (type == VmTypeName.BOOLEAN) {
                return BOOLEAN;
            }
            if (type == VmTypeName.BYTE) {
                return BYTE;
            }
            if (type == VmTypeName.CHAR) {
                return CHAR;
            }
            if (type == VmTypeName.DOUBLE) {
                return DOUBLE;
            }
            if (type == VmTypeName.FLOAT) {
                return FLOAT;
            }
            if (type == VmTypeName.INT) {
                return INT;
            }
            if (type == VmTypeName.LONG) {
                return LONG;
            }
            if (type == VmTypeName.VOID) {
                return VOID;
            }
            if (type == VmTypeName.SHORT) {
                return SHORT;
            }
        }
        return type.getClassName();
    }

    public static String vm2srcTypeName(String vmTypeDescriptor) {
        Checks.ensureIsNotNull(vmTypeDescriptor, "vmTypeName", new Object[0]);
        return Names.internal_vm2srcTypeName(vmTypeDescriptor.toCharArray(), 0);
    }

    @Beta
    public static IAnnotation vmType2vmAnnotation(ITypeName annotationType) {
        return VmAnnotation.get(annotationType);
    }

    public static ITypeName java2vmType(Class<?> clazz) {
        String vmName = Names.src2vmType(clazz.getName());
        return VmTypeName.get(vmName);
    }

    public static String jdt2vmType(String jdtTypeDescriptor) {
        Checks.ensureIsNotNull(jdtTypeDescriptor, "jdtTypeDescriptor", new Object[0]);
        String tmp = jdtTypeDescriptor;
        if (tmp.endsWith(";")) {
            tmp = StringUtils.removeStart((String)tmp, (String)"L");
            tmp = StringUtils.removeEnd((String)tmp, (String)";");
        }
        return Names.src2vmType(tmp);
    }

    public static enum PrimitiveType {
        BOOLEAN('Z', "boolean"),
        VOID('V', "void"),
        CHAR('C', "char"),
        BYTE('B', "byte"),
        SHORT('S', "short"),
        INT('I', "int"),
        FLOAT('F', "float"),
        LONG('J', "long"),
        DOUBLE('D', "double");

        private final String src;
        private final char vm;

        public static PrimitiveType fromSrc(String src) {
            Checks.ensureIsNotNull(src, "src", new Object[0]);
            PrimitiveType[] primitiveTypeArray = PrimitiveType.values();
            int n = primitiveTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrimitiveType t = primitiveTypeArray[n2];
                if (t.src.equals(src)) {
                    return t;
                }
                ++n2;
            }
            return null;
        }

        private PrimitiveType(char vm, String src) {
            this.vm = vm;
            this.src = src;
        }

        public String src() {
            return this.src;
        }

        public char vm() {
            return this.vm;
        }
    }
}

