/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.snipmatch.model.DefaultSnippetRepositoryConfigurationProvider;
import org.eclipse.recommenders.snipmatch.model.SnipmatchModelPackage;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelFactory;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;

public class RepositoryConfigurations {
    public static SnippetRepositoryConfigurations loadConfigurations(File file) {
        SnippetRepositoryConfigurations configurations = SnipmatchRcpModelFactory.eINSTANCE.createSnippetRepositoryConfigurations();
        if (!file.exists()) {
            return configurations;
        }
        try {
            Resource resource = RepositoryConfigurations.provideResource(file);
            resource.load(Collections.EMPTY_MAP);
            if (!resource.getContents().isEmpty()) {
                configurations = (SnippetRepositoryConfigurations)resource.getContents().get(0);
            }
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_LOADING_REPO_CONFIGURATION, (Object[])new Object[]{file, e});
        }
        return configurations;
    }

    private static Resource provideResource(File file) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("snipmatch", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createFileURI((String)file.getAbsolutePath()));
        return resource;
    }

    public static void storeConfigurations(SnippetRepositoryConfigurations configurations, File file) {
        Resource resource = RepositoryConfigurations.provideResource(file);
        resource.getContents().add((Object)configurations);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_STORING_REPO_CONFIGURATION, (Object[])new Object[]{file, e});
        }
    }

    protected static List<SnippetRepositoryConfiguration> fetchDefaultConfigurations() {
        IConfigurationElement[] elements;
        ArrayList defaultConfigurations = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.snipmatch.rcp.registeredEmfPackages");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                EPackage ePackage;
                String uri = element.getAttribute("uri");
                if (uri != null && (ePackage = EPackage.Registry.INSTANCE.getEPackage(uri)) != null) {
                    List<EClass> subtypes = RepositoryConfigurations.searchSubtypes(ePackage, SnipmatchModelPackage.Literals.DEFAULT_SNIPPET_REPOSITORY_CONFIGURATION_PROVIDER);
                    for (EClass eClass : subtypes) {
                        DefaultSnippetRepositoryConfigurationProvider configurationProvider = (DefaultSnippetRepositoryConfigurationProvider)Checks.cast((Object)EPackage.Registry.INSTANCE.getEFactory(uri).create(eClass));
                        EList subDefaultConfigurations = configurationProvider.getDefaultConfiguration();
                        for (SnippetRepositoryConfiguration config : subDefaultConfigurations) {
                            if (Strings.isNullOrEmpty((String)config.getId())) {
                                Logs.log((Logs.ILogMessage)LogMessages.ERROR_DEFAULT_REPO_CONFIGURATION_WITHOUT_ID);
                                continue;
                            }
                            config.setDefaultConfiguration(true);
                            defaultConfigurations.add(config);
                        }
                    }
                }
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_LOADING_DEFAULT_REPO_CONFIGURATION, (Throwable)e);
            }
            ++n2;
        }
        return defaultConfigurations;
    }

    private static List<EClass> searchSubtypes(EPackage ePackage, EClass eClass) {
        ArrayList subTypes = Lists.newArrayList();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass otherEClass;
            if (!(eClassifier instanceof EClass) || !eClass.isSuperTypeOf(otherEClass = (EClass)eClassifier) || eClass == otherEClass || otherEClass.isAbstract() || otherEClass.isInterface()) continue;
            subTypes.add((EClass)eClassifier);
        }
        return subTypes;
    }
}

