/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelPackage;

public final class Constants {
    static final String PLUGIN_ID = "org.eclipse.recommenders.stacktraces.rcp";
    static final String PREF_PAGE_ID = "org.eclipse.recommenders.stacktraces.rcp.preferencePages.errorReporting";
    static final String SYSPROP_SKIP_REPORTS = "org.eclipse.recommenders.stacktraces.rcp.skipReports";
    static final String SYSPROP_ECLIPSE_BUILD_ID = "eclipse.buildId";
    static final String PROP_NAME;
    static final String PROP_EMAIL;
    static final String PROP_ANONYMIZE_STACKTRACES;
    static final String PROP_ANONYMIZE_MESSAGES;
    static final String PROP_CONFIGURED;
    static final String PROP_SEND_ACTION;
    static final String PROP_REMEMBER_SEND_ACTION;
    static final String PROP_REMEMBER_SETTING_PERIOD_START;
    static final String PROP_SKIP_SIMILAR_ERRORS;
    static final String PROP_WHITELISTED_PLUGINS;
    static final String PROP_WHITELISTED_PACKAGES;
    static final String PROP_SERVER;
    static final String HELP_URL = "https://dev.eclipse.org/recommenders/community/confess/";
    static final String FEEDBACK_FORM_URL = "https://docs.google.com/a/codetrails.com/forms/d/1wd9AzydLv_TMa7ZBXHO7zQIhZjZCJRNMed-6J4fVNsc/viewform";
    static final String SERVER_URL;
    public static final int PREVIOUS_ERROR_CACHE_MAXIMUM_SIZE = 30;
    public static final int PREVIOUS_ERROR_CACHE_EXPIRE_AFTER_ACCESS_MINUTES = 10;
    public static final String WHITELISTED_PLUGINS = "org.eclipse.;org.apache.log4j;com.codetrails;";
    public static final String WHITELISTED_PACKAGES = "org.eclipse.;;;org.apache.;java.;javax.;javafx.;sun.;com.sun.;com.codetrails.;org.osgi.;com.google.;ch.qos.;org.slf4j.;";
    public static final Set<String> STAND_IN_STACKTRACE_BLACKLIST;
    public static final String HIDDEN = "HIDDEN";
    public static final String SOURCE_BEGIN_MESSAGE = "----------------------------------- SOURCE BEGIN -------------------------------------";
    public static final String SOURCE_FILE_REMOVED = "source file contents removed";
    public static final String VERSION = "0.6";

    static {
        ModelPackage pkg = ModelPackage.eINSTANCE;
        PROP_ANONYMIZE_STACKTRACES = pkg.getSettings_AnonymizeStrackTraceElements().getName();
        PROP_ANONYMIZE_MESSAGES = pkg.getSettings_AnonymizeMessages().getName();
        PROP_CONFIGURED = pkg.getSettings_Configured().getName();
        PROP_EMAIL = pkg.getSettings_Email().getName();
        PROP_NAME = pkg.getSettings_Name().getName();
        PROP_REMEMBER_SEND_ACTION = pkg.getSettings_RememberSendAction().getName();
        PROP_REMEMBER_SETTING_PERIOD_START = pkg.getSettings_RememberSendActionPeriodStart().getName();
        PROP_SEND_ACTION = pkg.getSettings_Action().getName();
        PROP_SERVER = pkg.getSettings_ServerUrl().getName();
        PROP_SKIP_SIMILAR_ERRORS = pkg.getSettings_SkipSimilarErrors().getName();
        PROP_WHITELISTED_PACKAGES = pkg.getSettings_WhitelistedPackages().getName();
        PROP_WHITELISTED_PLUGINS = pkg.getSettings_WhitelistedPluginIds().getName();
        SERVER_URL = Constants.getServerUrl();
        STAND_IN_STACKTRACE_BLACKLIST = ImmutableSet.of((Object)"java.security.AccessController", (Object)"org.eclipse.core.internal.runtime.Log", (Object)"org.eclipse.core.internal.runtime.RuntimeLog", (Object)"org.eclipse.core.internal.runtime.PlatformLogWriter", (Object)"org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory", (Object)"org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory$3", (Object[])new String[]{"org.eclipse.osgi.internal.log.ExtendedLogServiceFactory", "org.eclipse.osgi.internal.log.ExtendedLogServiceImpl", "org.eclipse.osgi.internal.log.LoggerImpl", "org.eclipse.recommenders.internal.stacktraces.rcp.StandInStacktraceProvider", "org.eclipse.recommenders.internal.stacktraces.rcp.LogListener"});
    }

    private Constants() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    private static String getServerUrl() {
        return System.getProperty("org.eclipse.recommenders.stacktraces.rcp." + PROP_SERVER, "https://dev.eclipse.org/recommenders/community/confess/0.5/reports/");
    }
}

