/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class Jobs {
    public static final ISchedulingRule EXCLUSIVE = new SequentialSchedulingRule();

    private Jobs() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static IProgressMonitor getProgressGroup() {
        return Job.getJobManager().createProgressGroup();
    }

    public static void parallel(String task, Job ... jobs) {
        Jobs.parallel(task, Arrays.asList(jobs));
    }

    public static void parallel(String task, Iterable<Job> jobs) {
        IProgressMonitor group = Jobs.getProgressGroup();
        group.beginTask(task, Iterables.size(jobs));
        for (Job job : jobs) {
            job.setProgressGroup(group, 1);
            job.schedule();
        }
    }

    public static void sequential(String task, Job ... jobs) {
        Jobs.sequential(task, Arrays.asList(jobs));
    }

    public static void sequential(String task, Iterable<Job> jobs) {
        SequentialSchedulingRule rule = new SequentialSchedulingRule();
        IProgressMonitor group = Jobs.getProgressGroup();
        group.beginTask(task, Iterables.size(jobs));
        for (Job job : jobs) {
            job.setRule((ISchedulingRule)rule);
            job.setProgressGroup(group, 1);
            job.schedule();
        }
    }

    public static final class SequentialSchedulingRule
    implements ISchedulingRule {
        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

