/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.recommenders.internal.stacktraces.rcp.Constants;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.RememberSendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static long MS_PER_DAY = TimeUnit.DAYS.toMillis(1L);
    private static Settings settings;

    public void initializeDefaultPreferences() {
        IEclipsePreferences s = DefaultScope.INSTANCE.getNode("org.eclipse.recommenders.stacktraces.rcp");
        s.put(Constants.PROP_SERVER, Constants.SERVER_URL);
        s.put(Constants.PROP_NAME, "");
        s.put(Constants.PROP_EMAIL, "");
        s.putBoolean(Constants.PROP_SKIP_SIMILAR_ERRORS, true);
        s.putBoolean(Constants.PROP_CONFIGURED, false);
        s.putLong(Constants.PROP_REMEMBER_SETTING_PERIOD_START, 0L);
        s.put(Constants.PROP_WHITELISTED_PLUGINS, "org.eclipse.;org.apache.log4j;com.codetrails;");
        s.put(Constants.PROP_WHITELISTED_PACKAGES, "org.eclipse.;;;org.apache.;java.;javax.;javafx.;sun.;com.sun.;com.codetrails.;org.osgi.;com.google.;ch.qos.;org.slf4j.;");
        s.put(Constants.PROP_SEND_ACTION, SendAction.ASK.name());
        s.put(Constants.PROP_REMEMBER_SEND_ACTION, RememberSendAction.NONE.name());
        s.putBoolean(Constants.PROP_ANONYMIZE_STACKTRACES, true);
        s.putBoolean(Constants.PROP_ANONYMIZE_MESSAGES, false);
    }

    public static Settings getDefault() {
        if (settings == null) {
            settings = ModelFactory.eINSTANCE.createSettings();
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp");
            EClass eClass = settings.eClass();
            PreferenceInitializer.loadFromPreferences(store, settings, eClass);
            PreferenceInitializer.registerPreferenceStoreChangeListener(store, settings, eClass);
            PreferenceInitializer.registerSettingsChangeListener(store, settings);
            PreferenceInitializer.handleRestart24hSendAction(settings);
        }
        return settings;
    }

    private static void registerSettingsChangeListener(final ScopedPreferenceStore store, Settings settings) {
        settings.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                Object feature = msg.getFeature();
                if (!(feature instanceof EAttribute)) {
                    return;
                }
                EAttribute attr = (EAttribute)feature;
                String key = attr.getName();
                EDataType type = attr.getEAttributeType();
                Object value = msg.getNewValue();
                String data = EcoreUtil.convertToString((EDataType)type, (Object)value);
                try {
                    store.putValue(key, data);
                    store.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void registerPreferenceStoreChangeListener(ScopedPreferenceStore store, final Settings settings, final EClass eClass) {
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                EStructuralFeature feature = eClass.getEStructuralFeature(property);
                if (feature != null && feature instanceof EAttribute) {
                    EAttribute attr = (EAttribute)feature;
                    EDataType type = attr.getEAttributeType();
                    String string = EcoreUtil.convertToString((EDataType)type, (Object)event.getNewValue());
                    Object value = EcoreUtil.createFromString((EDataType)type, (String)string);
                    settings.eSet(feature, value);
                }
            }
        });
    }

    private static void loadFromPreferences(ScopedPreferenceStore store, Settings settings, EClass eClass) {
        settings.eSetDeliver(false);
        for (EAttribute attr : eClass.getEAllAttributes()) {
            EDataType type = attr.getEAttributeType();
            String key = attr.getName();
            String value = store.getString(key);
            try {
                Object data = EcoreUtil.createFromString((EDataType)type, (String)value);
                settings.eSet((EStructuralFeature)attr, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        settings.eSetDeliver(true);
    }

    static void handleRestart24hSendAction(Settings settings) {
        switch (settings.getRememberSendAction()) {
            case RESTART: {
                settings.setAction(SendAction.ASK);
                settings.setRememberSendAction(RememberSendAction.NONE);
                break;
            }
            case HOURS_24: {
                boolean isDayElapsed;
                long elapsedTime = System.currentTimeMillis() - settings.getRememberSendActionPeriodStart();
                boolean bl = isDayElapsed = elapsedTime >= MS_PER_DAY;
                if (isDayElapsed) {
                    Logs.log((Logs.ILogMessage)LogMessages.PAUSE_PERIOD_ELAPSED);
                    settings.setAction(SendAction.ASK);
                }
                settings.setRememberSendAction(RememberSendAction.NONE);
            }
        }
    }
}

