/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Bundle;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.StackTraceElement;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Status;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Throwable;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Visitor;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.impl.VisitorImpl;
import org.eclipse.recommenders.utils.AnonymousId;
import org.eclipse.recommenders.utils.gson.EmfFieldExclusionStrategy;
import org.eclipse.recommenders.utils.gson.UuidTypeAdapter;

public class ErrorReports {
    private static ModelFactory factory = ModelFactory.eINSTANCE;

    static boolean isWhitelisted(String className, List<String> whitelist) {
        for (String whiteListedPrefix : whitelist) {
            if (!className.startsWith(whiteListedPrefix)) continue;
            return true;
        }
        return false;
    }

    public static ErrorReport copy(ErrorReport org) {
        return (ErrorReport)EcoreUtil.copy((EObject)org);
    }

    public static String toJson(ErrorReport report, Settings settings, boolean pretty) {
        report = ErrorReports.copy(report);
        report.setName(settings.getName());
        report.setEmail(settings.getEmail());
        if (settings.isAnonymizeStrackTraceElements()) {
            ErrorReports.anonymizeStackTrace(report, settings);
        }
        if (settings.isAnonymizeMessages()) {
            ErrorReports.clearMessages(report);
        }
        Gson gson = ErrorReports.createGson(pretty);
        String json = gson.toJson((Object)report);
        return json;
    }

    private static Gson createGson(boolean pretty) {
        GsonBuilder builder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        builder.registerTypeAdapter(UUID.class, (Object)new UuidTypeAdapter());
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new EmfFieldExclusionStrategy());
        if (pretty) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        return gson;
    }

    public static ErrorReport newErrorReport(IStatus event, Settings settings) {
        ErrorReport mReport = factory.createErrorReport();
        mReport.setAnonymousId(AnonymousId.getId());
        mReport.setName(settings.getName());
        mReport.setEmail(settings.getEmail());
        mReport.setJavaRuntimeVersion(SystemUtils.JAVA_RUNTIME_VERSION);
        mReport.setEclipseBuildId((String)ErrorReports.getEclipseBuildId().or((Object)"-"));
        mReport.setEclipseProduct(System.getProperty("eclipse.product", "-"));
        mReport.setOsgiArch(System.getProperty("osgi.arch", "-"));
        mReport.setOsgiWs(System.getProperty("osgi.ws", "-"));
        mReport.setOsgiOs(System.getProperty("org.osgi.framework.os.name", "-"));
        mReport.setOsgiOsVersion(System.getProperty("org.osgi.framework.os.version", "-"));
        mReport.setStatus(ErrorReports.newStatus(event, settings));
        return mReport;
    }

    public static Optional<String> getEclipseBuildId() {
        String res = System.getProperty("eclipse.buildId");
        return Optional.fromNullable((Object)res);
    }

    public static void guessInvolvedPlugins(ErrorReport report) {
        CollectStackTraceElementPackagesVisitor v = new CollectStackTraceElementPackagesVisitor();
        report.accept((Visitor)v);
        HashSet uniqueBundleNames = Sets.newHashSet();
        for (String packageName : v.packages) {
            while (packageName.contains(".")) {
                org.osgi.framework.Bundle guessedBundleForPackageName = Platform.getBundle((String)packageName);
                packageName = StringUtils.substringBeforeLast((String)packageName, (String)".");
                if (guessedBundleForPackageName == null || !uniqueBundleNames.add(guessedBundleForPackageName.getSymbolicName())) continue;
                Bundle bundle = factory.createBundle();
                bundle.setName(guessedBundleForPackageName.getSymbolicName());
                bundle.setVersion(guessedBundleForPackageName.getVersion().toString());
                report.getPresentBundles().add((Object)bundle);
            }
        }
    }

    @VisibleForTesting
    static Status newStatus(IStatus status, Settings settings) {
        boolean needFiltering;
        CoreException coreException;
        IStatus coreExceptionStatus22;
        Status mStatus = factory.createStatus();
        mStatus.setMessage(ErrorReports.removeSourceFileContents(status.getMessage()));
        mStatus.setSeverity(status.getSeverity());
        mStatus.setCode(status.getCode());
        mStatus.setPluginId(status.getPlugin());
        org.osgi.framework.Bundle bundle = Platform.getBundle((String)status.getPlugin());
        if (bundle != null) {
            mStatus.setPluginVersion(bundle.getVersion().toString());
        }
        EList mChildren = mStatus.getChildren();
        if (status.getException() instanceof CoreException && (coreExceptionStatus22 = (coreException = (CoreException)status.getException()).getStatus()) != null) {
            mChildren.add(ErrorReports.newStatus(coreExceptionStatus22, settings));
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int coreExceptionStatus22 = 0;
        while (coreExceptionStatus22 < n) {
            IStatus child = iStatusArray[coreExceptionStatus22];
            mChildren.add(ErrorReports.newStatus(child, settings));
            ++coreExceptionStatus22;
        }
        boolean bl = needFiltering = "org.eclipse.ui.monitoring".equals(status.getPlugin()) && (status.getCode() == 0 || status.getCode() == 1);
        if (needFiltering) {
            MultiStatusFilter.filter(mStatus);
        }
        if (status.getException() != null) {
            Throwable mException = ErrorReports.newThrowable(status.getException());
            mStatus.setException(mException);
        }
        mStatus.setFingerprint(ErrorReports.computeFingerprintFor(mStatus, settings));
        return mStatus;
    }

    public static String computeFingerprintFor(Status status, Settings settings) {
        ThrowableFingerprintComputer fingerprintComputer = new ThrowableFingerprintComputer(settings.getWhitelistedPackages(), 1024);
        status.accept((Visitor)fingerprintComputer);
        return fingerprintComputer.hash();
    }

    private static String removeSourceFileContents(String message) {
        if (message.contains("----------------------------------- SOURCE BEGIN -------------------------------------")) {
            return "source file contents removed";
        }
        return message;
    }

    public static Throwable newThrowable(java.lang.Throwable throwable) {
        Throwable mThrowable = factory.createThrowable();
        mThrowable.setMessage(throwable.getMessage());
        mThrowable.setClassName(throwable.getClass().getName());
        EList mStackTrace = mThrowable.getStackTrace();
        java.lang.StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            StackTraceElement mStackTraceElement = factory.createStackTraceElement();
            mStackTraceElement.setFileName(stackTraceElement.getFileName());
            mStackTraceElement.setClassName(stackTraceElement.getClassName());
            mStackTraceElement.setMethodName(stackTraceElement.getMethodName());
            mStackTraceElement.setLineNumber(stackTraceElement.getLineNumber());
            mStackTrace.add(mStackTraceElement);
            ++n2;
        }
        java.lang.Throwable cause = throwable.getCause();
        if (cause != null) {
            if (cause == throwable) {
                System.out.println("err");
            }
            mThrowable.setCause(ErrorReports.newThrowable(cause));
        }
        return mThrowable;
    }

    public static void clearMessages(ErrorReport event) {
        event.accept((Visitor)new ClearMessagesVisitor());
    }

    public static void anonymizeStackTrace(ErrorReport report, Settings settings) {
        report.accept((Visitor)new AnonymizeStacktraceVisitor(settings.getWhitelistedPackages()));
    }

    public static String prettyPrint(ErrorReport report, Settings settings) {
        if (settings.isAnonymizeStrackTraceElements()) {
            ErrorReports.anonymizeStackTrace(report, settings);
        }
        if (settings.isAnonymizeMessages()) {
            ErrorReports.clearMessages(report);
        }
        PrettyPrintVisitor prettyPrintVisitor = new PrettyPrintVisitor();
        report.accept((Visitor)prettyPrintVisitor);
        return prettyPrintVisitor.print();
    }

    public static String getFingerprint(ErrorReport report) {
        return report.getStatus().getFingerprint();
    }

    public static final class AnonymizeStacktraceVisitor
    extends VisitorImpl {
        private List<String> whitelist;

        public AnonymizeStacktraceVisitor(List<String> whitelist) {
            this.whitelist = whitelist;
        }

        public void visit(Throwable throwable) {
            if (!ErrorReports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                throwable.setClassName("HIDDEN");
            }
        }

        public void visit(StackTraceElement element) {
            if (!ErrorReports.isWhitelisted(element.getClassName(), this.whitelist)) {
                element.setClassName("HIDDEN");
                element.setMethodName("HIDDEN");
                element.setFileName("HIDDEN");
                element.setLineNumber(-1);
            }
        }
    }

    public static final class ClearMessagesVisitor
    extends VisitorImpl {
        public void visit(Status status) {
            status.setMessage("HIDDEN");
        }

        public void visit(Throwable throwable) {
            throwable.setMessage("HIDDEN");
        }
    }

    public static final class CollectStackTraceElementPackagesVisitor
    extends VisitorImpl {
        public TreeSet<String> packages = Sets.newTreeSet();

        public void visit(StackTraceElement element) {
            String pkg = StringUtils.replace((String)StringUtils.substringBeforeLast((String)element.getClassName(), (String)"."), (String)".internal.", (String)".");
            this.packages.add(pkg);
        }
    }

    private static class MultiStatusFilter {
        private MultiStatusFilter() {
        }

        private static void filter(Status status) {
            HashSet<Throwable> throwables = new HashSet<Throwable>();
            MultiStatusFilter.filter(status, throwables);
        }

        private static void filter(Status status, Set<Throwable> throwables) {
            EList children = status.getChildren();
            int removedCount = 0;
            int i = children.size() - 1;
            while (i >= 0) {
                Status childStatus = (Status)children.get(i);
                if (MultiStatusFilter.filterChild(childStatus, throwables)) {
                    children.remove(i);
                    ++removedCount;
                } else {
                    MultiStatusFilter.filter(childStatus, throwables);
                }
                --i;
            }
            if (removedCount > 0) {
                status.setMessage(String.format("%s [%d child-status duplicates removed by Error Reporting]", status.getMessage(), removedCount));
            }
        }

        private static boolean filterChild(Status status, Set<Throwable> throwables) {
            Throwable throwable = status.getException();
            if (throwable.getStackTrace().isEmpty()) {
                return true;
            }
            for (Throwable t : throwables) {
                if (!MultiStatusFilter.stackTraceMatches(throwable, t)) continue;
                return true;
            }
            throwables.add(throwable);
            return false;
        }

        private static boolean stackTraceMatches(Throwable throwable, Throwable t) {
            EList stackTrace = throwable.getStackTrace();
            EList stackTrace2 = t.getStackTrace();
            if (stackTrace.size() != stackTrace2.size()) {
                return false;
            }
            int i = 0;
            while (i < stackTrace.size()) {
                StackTraceElement ste = (StackTraceElement)stackTrace.get(i);
                StackTraceElement ste2 = (StackTraceElement)stackTrace2.get(i);
                if (!ste.getClassName().equals(ste2.getClassName()) || !ste.getMethodName().equals(ste2.getMethodName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public static class PrettyPrintVisitor
    extends VisitorImpl {
        private static final int RIGHT_PADDING = 20;
        private StringBuilder reportStringBuilder = new StringBuilder();
        private StringBuilder statusStringBuilder = new StringBuilder();
        private StringBuilder bundlesStringBuilder = new StringBuilder();

        public PrettyPrintVisitor() {
            this.appendHeadline("BUNDLES", this.bundlesStringBuilder);
        }

        private void appendAttributes(EObject object, StringBuilder builder) {
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                String line = String.valueOf(String.format("%-20s", String.valueOf(attribute.getName()) + ":")) + object.eGet((EStructuralFeature)attribute) + "\n";
                builder.append(line);
            }
            builder.append("\n");
        }

        private void appendHeadline(String headline, StringBuilder builder) {
            if (builder.length() != 0) {
                builder.append("\n");
            }
            String line = String.valueOf(headline.replaceAll(".", "-")) + "\n";
            builder.append(line);
            builder.append(String.valueOf(headline) + "\n");
            builder.append(line);
        }

        public void visit(ErrorReport report) {
            this.appendHeadline("REPORT", this.reportStringBuilder);
            this.appendAttributes((EObject)report, this.reportStringBuilder);
            super.visit(report);
        }

        public void visit(Status status) {
            this.appendHeadline("STATUS", this.statusStringBuilder);
            this.appendAttributes((EObject)status, this.statusStringBuilder);
            this.statusStringBuilder.append("Exception:");
            Throwable exception = status.getException();
            if (exception != null) {
                this.append(exception, this.statusStringBuilder);
            } else {
                this.statusStringBuilder.append("null");
            }
            super.visit(status);
        }

        private void append(Throwable throwable, StringBuilder builder) {
            builder.append(String.format("%s: %s\n", throwable.getClassName(), throwable.getMessage()));
            for (StackTraceElement element : throwable.getStackTrace()) {
                builder.append(String.format("\t at %s.%s(%s:%s)\n", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()));
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                this.statusStringBuilder.append("Caused by: ");
                this.append(cause, builder);
            }
        }

        public void visit(Bundle bundle) {
            this.appendAttributes((EObject)bundle, this.bundlesStringBuilder);
            super.visit(bundle);
        }

        public String print() {
            return this.statusStringBuilder + "\n" + this.reportStringBuilder + this.bundlesStringBuilder;
        }
    }

    public static final class ThrowableFingerprintComputer
    extends VisitorImpl {
        private StringBuilder content = new StringBuilder();
        private List<String> whitelist;
        private int maxframes;

        public ThrowableFingerprintComputer(List<String> whitelist, int maxframes) {
            this.whitelist = whitelist;
            this.maxframes = maxframes;
        }

        public void visit(StackTraceElement element) {
            if (this.maxframes < 0) {
                return;
            }
            --this.maxframes;
            if (ErrorReports.isWhitelisted(element.getClassName(), this.whitelist)) {
                this.content.append(element.getClassName()).append(element.getMethodName());
            }
        }

        public void visit(Throwable throwable) {
            if (ErrorReports.isWhitelisted(throwable.getClassName(), this.whitelist)) {
                this.content.append(throwable.getClassName());
            }
        }

        public String hash() {
            return Hashing.murmur3_32().hashUnencodedChars((CharSequence)this.content.toString()).toString();
        }
    }
}

