/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import com.google.common.eventbus.EventBus;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.apidocs.rcp.LogMessages;
import org.eclipse.recommenders.internal.apidocs.rcp.Messages;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StaticHooksProvider
extends ApidocProvider {
    private final EventBus workspaceBus;

    @Inject
    public StaticHooksProvider(EventBus workspaceBus) {
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public void onPackageRootSelection(IPackageFragmentRoot root, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        TreeMultimap index = TreeMultimap.create((Comparator)new TypeNameComparator(), (Comparator)new MethodNameComparator());
        try {
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                if (e.getElementType() == 4) {
                    IPackageFragment pkg = (IPackageFragment)e;
                    this.findStaticHooks(pkg, (TreeMultimap<IType, IMethod>)index);
                    pkg.close();
                }
                ++n2;
            }
        }
        catch (Exception x) {
            Logs.log((Logs.ILogMessage)LogMessages.FAILED_TO_DETERMINE_STATIC_MEMBERS, (Throwable)x, (Object[])new Object[]{root.getElementName()});
        }
        this.runSyncInUiThread(new HooksRendererRunnable(index, parent));
    }

    @JavaSelectionSubscriber
    public void onPackageSelection(IPackageFragment pkg, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        TreeMultimap index = TreeMultimap.create((Comparator)new TypeNameComparator(), (Comparator)new MethodNameComparator());
        try {
            this.findStaticHooks(pkg, (TreeMultimap<IType, IMethod>)index);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.FAILED_TO_DETERMINE_STATIC_MEMBERS, (Throwable)e, (Object[])new Object[]{pkg.getElementName()});
        }
        this.runSyncInUiThread(new HooksRendererRunnable(index, parent));
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(ILocalVariable var, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = (IType)ApidocsViewUtils.findType(var).orNull();
        if (type != null) {
            this.onPackageSelection(type.getPackageFragment(), event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(IField var, JavaElementSelectionEvent event, Composite parent) throws ExecutionException, JavaModelException {
        IType type = (IType)ApidocsViewUtils.findType(var).orNull();
        if (type != null) {
            this.onPackageSelection(type.getPackageFragment(), event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onJavaElementSelection(IJavaElement e, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        IPackageFragment pkg = (IPackageFragment)e.getAncestor(4);
        if (pkg != null) {
            this.onPackageSelection(pkg, event, parent);
        }
    }

    private void findStaticHooks(IPackageFragment pkg, TreeMultimap<IType, IMethod> index) throws JavaModelException {
        IClassFile f;
        IClassFile[] iClassFileArray = pkg.getClassFiles();
        int n = iClassFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iClassFileArray[n2];
            this.findStaticHooks(index, (ITypeRoot)f);
            ++n2;
        }
        iClassFileArray = pkg.getCompilationUnits();
        n = iClassFileArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iClassFileArray[n2];
            this.findStaticHooks(index, (ITypeRoot)f);
            ++n2;
        }
    }

    private void findStaticHooks(TreeMultimap<IType, IMethod> index, ITypeRoot root) throws JavaModelException {
        IType type = root.findPrimaryType();
        if (type == null) {
            return;
        }
        if (!type.isClass()) {
            return;
        }
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (JdtFlags.isStatic((IMember)m) && JdtFlags.isPublic((IMember)m) && !JdtUtils.isInitializer((IMethod)m)) {
                index.put((Object)type, (Object)m);
            }
            ++n2;
        }
    }

    private final class HooksRendererRunnable
    implements Runnable {
        private final TreeMultimap<IType, IMethod> index;
        private final Composite parent;
        private StyledText styledText;

        private HooksRendererRunnable(TreeMultimap<IType, IMethod> index, Composite parent) {
            this.index = index;
            this.parent = parent;
        }

        @Override
        public void run() {
            Composite container = ApidocsViewUtils.createComposite(this.parent, 1);
            if (this.index.isEmpty()) {
                ApidocsViewUtils.createLabel(container, Messages.PROVIDER_INTRO_NO_STATIC_HOOKS_FOUND, true);
            }
            LinkedList typeRanges = Lists.newLinkedList();
            StringBuilder sb = new StringBuilder();
            for (IType type : this.index.keySet()) {
                String typeLabel = type.getFullyQualifiedName();
                int typeLabelBegin = sb.length();
                sb.append(typeLabel);
                int typeLabelEnd = sb.length();
                StyleRange styleRange = new StyleRange();
                styleRange.rise = -12;
                styleRange.start = typeLabelBegin;
                styleRange.length = typeLabelEnd - typeLabelBegin;
                styleRange.fontStyle = 1;
                styleRange.data = type;
                styleRange.font = JFaceResources.getHeaderFont();
                typeRanges.add(styleRange);
                sb.append(IOUtils.LINE_SEPARATOR);
                for (IMethod method : this.index.get((Object)type)) {
                    sb.append("    ");
                    int methodLabelBegin = sb.length();
                    String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)method, (long)33L);
                    sb.append(methodLabel);
                    int methodLabelEnd = sb.length();
                    StyleRange methodStyleRange = new StyleRange();
                    methodStyleRange.start = methodLabelBegin;
                    methodStyleRange.length = methodLabelEnd - methodLabelBegin;
                    methodStyleRange.data = method;
                    methodStyleRange.underline = true;
                    methodStyleRange.font = JFaceResources.getDialogFont();
                    methodStyleRange.foreground = Display.getDefault().getSystemColor(9);
                    typeRanges.add(methodStyleRange);
                    sb.append(IOUtils.LINE_SEPARATOR);
                }
            }
            this.styledText = new StyledText(container, 0);
            this.styledText.setRedraw(false);
            this.styledText.setLayoutData((Object)new GridData(4, 4, true, true));
            ApidocsViewUtils.setInfoBackgroundColor((Control)this.styledText);
            ApidocsViewUtils.setInfoForegroundColor((Control)this.styledText);
            this.styledText.setEditable(false);
            this.styledText.setText(sb.toString());
            this.styledText.setStyleRanges(typeRanges.toArray(new StyleRange[0]));
            final Cursor c1 = Display.getDefault().getSystemCursor(0);
            final Cursor c2 = Display.getDefault().getSystemCursor(21);
            this.styledText.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    Optional opt = HooksRendererRunnable.this.getSelectedMethod(event.x, event.y);
                    if (opt.isPresent()) {
                        JavaElementSelectionEvent sEvent = new JavaElementSelectionEvent((IJavaElement)opt.get(), JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
                        StaticHooksProvider.this.workspaceBus.post((Object)sEvent);
                    }
                }
            });
            this.styledText.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    Optional opt = HooksRendererRunnable.this.getSelectedMethod(e.x, e.y);
                    if (opt.isPresent()) {
                        HooksRendererRunnable.this.styledText.setCursor(c2);
                    } else {
                        HooksRendererRunnable.this.styledText.setCursor(c1);
                    }
                }
            });
            this.styledText.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                }

                public void mouseEnter(MouseEvent e) {
                }
            });
            this.styledText.setRedraw(true);
        }

        private Optional<StyleRange> getSelectedStyleRange(int x, int y) {
            try {
                int offset = this.styledText.getOffsetAtLocation(new Point(x, y));
                StyleRange style = this.styledText.getStyleRangeAtOffset(offset);
                return Optional.fromNullable((Object)style);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Optional.absent();
            }
        }

        private Optional<IMethod> getSelectedMethod(int x, int y) {
            Optional<StyleRange> range = this.getSelectedStyleRange(x, y);
            if (!range.isPresent()) {
                return Optional.absent();
            }
            Object data = ((StyleRange)range.get()).data;
            if (data instanceof IMethod) {
                return Optional.of((Object)((IMethod)data));
            }
            return Optional.absent();
        }
    }

    private static class MethodNameComparator
    implements Comparator<IMethod> {
        private MethodNameComparator() {
        }

        @Override
        public int compare(IMethod o1, IMethod o2) {
            String s1 = JavaElementLabels.getElementLabel((IJavaElement)o1, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
            String s2 = JavaElementLabels.getElementLabel((IJavaElement)o2, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
            return s1.compareTo(s2);
        }
    }

    private static class TypeNameComparator
    implements Comparator<IType> {
        private TypeNameComparator() {
        }

        @Override
        public int compare(IType arg0, IType arg1) {
            String s0 = arg0.getFullyQualifiedName();
            String s1 = arg1.getFullyQualifiedName();
            return s0.compareTo(s1);
        }
    }
}

