/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaAllCompletionProposalComputer;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessorDescriptor;
import org.eclipse.recommenders.internal.completion.rcp.CompletionRcpPreferences;
import org.eclipse.recommenders.internal.completion.rcp.EmptyCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.EnableCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.LogMessages;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;

public class IntelligentCompletionProposalComputer
extends JavaAllCompletionProposalComputer
implements ICompletionListener,
ICompletionListenerExtension2 {
    private final CompletionRcpPreferences preferences;
    private final IAstProvider astProvider;
    private final SharedImages images;
    private final Map<CompletionContextKey, ICompletionContextFunction> functions;
    private final IProcessableProposalFactory proposalFactory = new ProcessableProposalFactory();
    private final Set<SessionProcessor> processors = Sets.newLinkedHashSet();
    private final Set<SessionProcessor> activeProcessors = Sets.newLinkedHashSet();
    public JavaContentAssistInvocationContext jdtContext;
    public IRecommendersCompletionContext crContext;
    public ContentAssistantFacade contentAssist;

    @Inject
    public IntelligentCompletionProposalComputer(CompletionRcpPreferences preferences, IAstProvider astProvider, SharedImages images, Map<CompletionContextKey, ICompletionContextFunction> functions) {
        this.preferences = preferences;
        this.astProvider = astProvider;
        this.images = images;
        this.functions = functions;
    }

    public void sessionStarted() {
        this.processors.clear();
        for (SessionProcessorDescriptor d : this.preferences.getEnabledSessionProcessors()) {
            try {
                this.processors.add(d.getProcessor());
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{d.getId()});
            }
        }
        this.activeProcessors.clear();
        this.activeProcessors.addAll(this.processors);
        this.unregisterCompletionListener();
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        this.storeContext(context);
        if (!this.isContentAssistConfigurationOkay()) {
            boolean hasOtherProposals;
            int offset = context.getInvocationOffset();
            EnableCompletionProposal config = new EnableCompletionProposal(this.images, offset);
            boolean bl = hasOtherProposals = !this.crContext.getProposals().isEmpty();
            if (hasOtherProposals) {
                return ImmutableList.of((Object)((Object)config));
            }
            return ImmutableList.of((Object)((Object)config), (Object)((Object)new EmptyCompletionProposal(offset)));
        }
        LinkedList res = Lists.newLinkedList();
        this.registerCompletionListener();
        this.crContext.set(CompletionContextKey.ACTIVE_PROCESSORS, ImmutableSet.copyOf(this.activeProcessors));
        this.fireInitializeContext(this.crContext);
        this.fireStartSession(this.crContext);
        for (Map.Entry<IJavaCompletionProposal, CompletionProposal> pair : this.crContext.getProposals().entrySet()) {
            IJavaCompletionProposal jdtProposal = ProcessableProposalFactory.create(pair.getValue(), pair.getKey(), this.jdtContext, this.proposalFactory);
            res.add(jdtProposal);
            if (!(jdtProposal instanceof IProcessableProposal)) continue;
            IProcessableProposal crProposal = (IProcessableProposal)jdtProposal;
            crProposal.setTag(ProposalTag.CONTEXT, this.crContext);
            crProposal.setTag(ProposalTag.IS_VISIBLE, true);
            crProposal.setTag(ProposalTag.JDT_UI_PROPOSAL, pair.getKey());
            crProposal.setTag(ProposalTag.JDT_CORE_PROPOSAL, pair.getValue());
            crProposal.setTag(ProposalTag.JDT_SCORE, jdtProposal.getRelevance());
            this.fireProcessProposal(crProposal);
        }
        this.fireEndComputation(res);
        this.fireAboutToShow(res);
        return res;
    }

    public void sessionEnded() {
        this.fireAboutToClose();
    }

    private void storeContext(ContentAssistInvocationContext context) {
        this.jdtContext = (JavaContentAssistInvocationContext)Checks.cast((Object)context);
        this.crContext = new RecommendersCompletionContext(this.jdtContext, this.astProvider, this.functions);
    }

    protected boolean isContentAssistConfigurationOkay() {
        HashSet cats = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
        if (cats.contains("org.eclipse.recommenders.completion.rcp.proposalCategory.intelligent")) {
            return true;
        }
        return !this.isJdtAllEnabled(cats) && !this.isMylynInstalledAndEnabled(cats);
    }

    private boolean isMylynInstalledAndEnabled(Set<String> cats) {
        return this.isMylynInstalled() && !cats.contains("org.eclipse.mylyn.java.ui.javaAllProposalCategory");
    }

    private boolean isJdtAllEnabled(Set<String> cats) {
        return !cats.contains("org.eclipse.jdt.ui.javaAllProposalCategory");
    }

    private boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals("org.eclipse.mylyn.java.ui.javaAllProposalCategory")) continue;
            return true;
        }
        return false;
    }

    private void registerCompletionListener() {
        ITextViewer v = this.jdtContext.getViewer();
        if (!(v instanceof SourceViewer)) {
            return;
        }
        SourceViewer sv = (SourceViewer)v;
        this.contentAssist = sv.getContentAssistantFacade();
        this.contentAssist.addCompletionListener((ICompletionListener)this);
    }

    private void unregisterCompletionListener() {
        if (this.contentAssist != null) {
            this.contentAssist.removeCompletionListener((ICompletionListener)this);
        }
    }

    protected void fireInitializeContext(IRecommendersCompletionContext crContext) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.initializeContext(crContext);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireStartSession(IRecommendersCompletionContext crContext) {
        Iterator<SessionProcessor> it = this.activeProcessors.iterator();
        while (it.hasNext()) {
            SessionProcessor p = it.next();
            try {
                boolean interested = p.startSession(crContext);
                if (interested) continue;
                it.remove();
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireProcessProposal(IProcessableProposal proposal) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                proposal.getRelevance();
                p.process(proposal);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
        proposal.getProposalProcessorManager().prefixChanged(this.crContext.getPrefix());
    }

    protected void fireEndComputation(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.endSession(proposals);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireAboutToShow(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.aboutToShow(proposals);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireAboutToClose() {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.aboutToClose();
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.selected(proposal);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void applied(ICompletionProposal proposal) {
        for (SessionProcessor p : this.activeProcessors) {
            try {
                p.applied(proposal);
            }
            catch (Throwable e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_SESSION_PROCESSOR_FAILED, (Throwable)e, (Object[])new Object[]{p.getClass()});
            }
        }
        this.unregisterCompletionListener();
    }
}

