/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Optional;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.swt.graphics.Image;

public final class Proposals {
    private Proposals() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static void overlay(IProcessableProposal proposal, ImageDescriptor icon) {
        Proposals.overlay(proposal, icon, 0);
    }

    public static void overlay(IProcessableProposal proposal, ImageDescriptor icon, int decorationCorner) {
        Image originalImage = proposal.getImage();
        DecorationOverlayIcon decorator = new DecorationOverlayIcon(originalImage, icon, decorationCorner);
        proposal.setImage(decorator.createImage());
    }

    public static IRecommendersCompletionContext getContext(IProcessableProposal proposal) {
        return (IRecommendersCompletionContext)proposal.getTag(ProposalTag.CONTEXT).orNull();
    }

    public static String getPrefix(IProcessableProposal proposal) {
        String prefix = proposal.getPrefix();
        if (prefix == null) {
            prefix = Proposals.getContext(proposal).getPrefix();
        }
        return prefix;
    }

    public static Optional<CompletionProposal> getCoreProposal(ICompletionProposal proposal) {
        if (proposal instanceof IProcessableProposal) {
            IProcessableProposal pp = (IProcessableProposal)proposal;
            return pp.getCoreProposal();
        }
        return Optional.absent();
    }

    public static <T> Optional<T> getTag(ICompletionProposal proposal, String tag) {
        if (proposal instanceof IProcessableProposal) {
            IProcessableProposal pp = (IProcessableProposal)proposal;
            for (IProposalTag t : pp.tags()) {
                if (!t.name().equals(tag)) continue;
                return pp.getTag(t);
            }
        }
        return Optional.absent();
    }

    public static boolean isKindOneOf(ICompletionProposal proposal, int ... kinds) {
        CompletionProposal cp = (CompletionProposal)Proposals.getCoreProposal(proposal).orNull();
        if (cp != null) {
            int[] nArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                int kind = nArray[n2];
                if (cp.getKind() == kind) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

